/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.economy.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.hooks.economy.EconomyHook;
import ch.njol.skript.hooks.economy.classes.Money;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

@Name(value="Money")
@Description(value={"How much virtual money a player has (can be changed). This expression requires Vault and a compatible economy plugin to be installed."})
@Examples(value={"message \"You have %player's money%\" # the currency name will be added automatically", "remove 20$ from the player's balance # replace '$' by whatever currency you use", "add 200 to the player's account # or omit the currency alltogether"})
@Since(value="2.0")
public class ExprBalance
extends SimplePropertyExpression<OfflinePlayer, Money> {
    static {
        ExprBalance.register(ExprBalance.class, Money.class, "(money|balance|[bank] account)", "players");
    }

    @Override
    public Money convert(OfflinePlayer p) {
        return new Money(EconomyHook.economy.getBalance(p.getName()));
    }

    @Override
    public Class<? extends Money> getReturnType() {
        return Money.class;
    }

    @Override
    protected String getPropertyName() {
        return "money";
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        return new Class[]{Money.class, Number.class};
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        if (mode == Changer.ChangeMode.DELETE) {
            OfflinePlayer[] offlinePlayerArray = (OfflinePlayer[])this.getExpr().getAll(e);
            int n = offlinePlayerArray.length;
            int n2 = 0;
            while (n2 < n) {
                OfflinePlayer p = offlinePlayerArray[n2];
                EconomyHook.economy.withdrawPlayer(p.getName(), EconomyHook.economy.getBalance(p.getName()));
                ++n2;
            }
            return;
        }
        double m = delta instanceof Number ? ((Number)delta).doubleValue() : ((Money)delta).getAmount();
        OfflinePlayer[] offlinePlayerArray = (OfflinePlayer[])this.getExpr().getAll(e);
        int n = offlinePlayerArray.length;
        int n3 = 0;
        while (n3 < n) {
            OfflinePlayer p = offlinePlayerArray[n3];
            switch (mode) {
                case SET: {
                    double b = EconomyHook.economy.getBalance(p.getName());
                    if (b < m) {
                        EconomyHook.economy.depositPlayer(p.getName(), m - b);
                        break;
                    }
                    if (!(b > m)) break;
                    EconomyHook.economy.withdrawPlayer(p.getName(), b - m);
                    break;
                }
                case ADD: {
                    EconomyHook.economy.depositPlayer(p.getName(), m);
                    break;
                }
                case REMOVE: {
                    EconomyHook.economy.withdrawPlayer(p.getName(), m);
                    break;
                }
                case REMOVE_ALL: 
                case DELETE: 
                case RESET: {
                    assert (false);
                    break;
                }
            }
            ++n3;
        }
    }
}

