/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.base;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.SerializableConverter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Converters;
import java.util.Iterator;
import org.bukkit.event.Event;

public abstract class WrapperExpression<T>
extends SimpleExpression<T> {
    private Expression<? extends T> expr;

    protected WrapperExpression() {
    }

    public WrapperExpression(SimpleExpression<? extends T> expr) {
        assert (expr != null);
        this.setExpr(expr);
    }

    protected void setExpr(Expression<? extends T> expr) {
        assert (expr != null);
        this.expr = expr;
    }

    public Expression<?> getExpr() {
        return this.expr;
    }

    @Override
    protected <R> ConvertedExpression<T, ? extends R> getConvertedExpr(Class<R> to) {
        SerializableConverter<T, R> conv = Converters.getConverter(this.getReturnType(), to);
        if (conv == null) {
            return null;
        }
        return new ConvertedExpression<T, R>(this.expr, to, conv){

            @Override
            public String toString(Event e, boolean debug) {
                if (debug && e == null) {
                    return "(" + WrapperExpression.this.toString(e, debug) + ")->" + this.to.getName();
                }
                return WrapperExpression.this.toString(e, debug);
            }
        };
    }

    @Override
    protected T[] get(Event e) {
        return this.expr.getArray(e);
    }

    @Override
    public Iterator<? extends T> iterator(Event e) {
        return this.expr.iterator(e);
    }

    @Override
    public boolean isSingle() {
        return this.expr.isSingle();
    }

    @Override
    public boolean getAnd() {
        return this.expr.getAnd();
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.expr.getReturnType();
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return this.expr.acceptChange(mode);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        this.expr.change(e, delta, mode);
    }

    @Override
    public boolean setTime(int time) {
        return this.expr.setTime(time);
    }

    @Override
    public int getTime() {
        return this.expr.getTime();
    }

    @Override
    public boolean isDefault() {
        return this.expr.isDefault();
    }

    @Override
    public Expression<? extends T> simplify() {
        return this.expr;
    }
}

