/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

@Name(value="World")
@Description(value={"The world the event occurred in."})
@Examples(value={"world is \"world_nether\"", "teleport the player to the world's spawn", "set the weather in the player's world to rain"})
@Since(value="1.0")
public class ExprWorld
extends PropertyExpression<Object, World> {
    static {
        Skript.registerExpression(ExprWorld.class, World.class, ExpressionType.PROPERTY, "[the] world [of %-entity/location%]", "%entity/location%'[s] world");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (exprs[0] == null) {
            exprs[0] = new EventValueExpression<World>(World.class);
            if (!((DefaultExpression)exprs[0]).init()) {
                return false;
            }
        }
        this.setExpr(exprs[0]);
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the world" + (this.getExpr().isDefault() ? "" : " of " + this.getExpr().toString(e, debug));
    }

    @Override
    public Class<World> getReturnType() {
        return World.class;
    }

    protected World[] get(Event e, Object[] source) {
        if (this.getExpr().isDefault() && e instanceof PlayerTeleportEvent && this.getTime() > 0 && !Delay.isDelayed(e)) {
            return new World[]{((PlayerTeleportEvent)e).getTo().getWorld()};
        }
        if (source instanceof World[]) {
            return (World[])source;
        }
        return this.get(source, new Converter<Object, World>(){

            @Override
            public World convert(Object o) {
                if (o instanceof Entity) {
                    return ((Entity)o).getWorld();
                }
                if (o instanceof Location) {
                    return ((Location)o).getWorld();
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError(o);
                }
                return null;
            }
        });
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), PlayerTeleportEvent.class);
    }
}

