/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.Slot;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Name(value="Tool")
@Description(value={"The item a player is holding."})
@Examples(value={"player is holding a pickaxe", "# is the same as", "player's tool is a pickaxe"})
@Since(value="1.0")
public class ExprTool
extends PropertyExpression<Player, Slot> {
    static {
        Skript.registerExpression(ExprTool.class, Slot.class, ExpressionType.PROPERTY, "[the] (tool|held item) [of %players%]", "%player%'[s] (tool|held item)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Slot[] get(final Event e, Player[] source) {
        if (this.getExpr().isDefault() && !Delay.isDelayed(e)) {
            if (e instanceof PlayerItemHeldEvent) {
                return new Slot[]{new Slot((Inventory)((PlayerItemHeldEvent)e).getPlayer().getInventory(), this.getTime() >= 0 ? ((PlayerItemHeldEvent)e).getNewSlot() : ((PlayerItemHeldEvent)e).getPreviousSlot())};
            }
            if (e instanceof PlayerBucketEvent) {
                return new Slot[]{new Slot((Inventory)((PlayerBucketEvent)e).getPlayer().getInventory(), ((PlayerBucketEvent)e).getPlayer().getInventory().getHeldItemSlot()){

                    @Override
                    public ItemStack getItem() {
                        return ExprTool.this.getTime() <= 0 ? super.getItem() : ((PlayerBucketEvent)e).getItemStack();
                    }

                    @Override
                    public void setItem(ItemStack item) {
                        if (ExprTool.this.getTime() >= 0) {
                            ((PlayerBucketEvent)e).setItemStack(item);
                        } else {
                            super.setItem(item);
                        }
                    }
                }};
            }
        }
        return this.get(source, new Getter<Slot, Player>(){

            @Override
            public Slot get(final Player p) {
                return new Slot((Inventory)p.getInventory(), p.getInventory().getHeldItemSlot()){

                    @Override
                    public void setItem(ItemStack item) {
                        p.setItemInHand(item);
                    }

                    @Override
                    public ItemStack getItem() {
                        return p.getItemInHand();
                    }

                    @Override
                    public String toString(Event e, boolean debug) {
                        return "the " + (ExprTool.this.getTime() == 1 ? "future " : (ExprTool.this.getTime() == -1 ? "former " : "")) + "tool of " + p.getName();
                    }
                };
            }
        });
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the " + (this.getTime() == 1 ? "future " : (this.getTime() == -1 ? "former " : "")) + "tool of " + this.getExpr().toString(e, debug);
        }
        return Classes.getDebugMessage(this.getSingle(e));
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), PlayerItemHeldEvent.class, PlayerBucketFillEvent.class, PlayerBucketEmptyEvent.class);
    }
}

