/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.CollectionUtils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

@Name(value="Random")
@Description(value={"Gets a random item out of a set, e.g. a random player out of all players online."})
@Examples(value={"give a diamond to a random player out of all players", "give a random item out of all items to the player"})
@Since(value="1.4.9")
public class ExprRandom
extends SimpleExpression<Object> {
    private Expression<?> expr;

    static {
        Skript.registerExpression(ExprRandom.class, Object.class, ExpressionType.COMBINED, "[a] random %*classinfo% [out] of %objects%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.expr = exprs[1].getConvertedExpression(((ClassInfo)exprs[0].getSingle(null)).getC());
        return this.expr != null;
    }

    @Override
    protected Object[] get(Event e) {
        Object[] set = this.expr.getAll(e);
        if (set.length <= 1) {
            return set;
        }
        Object[] one = (Object[])Array.newInstance(set.getClass().getComponentType(), 1);
        one[0] = CollectionUtils.random(set);
        return one;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.expr.getReturnType();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "a random element out of " + this.expr.toString(e, debug);
    }

    @Override
    public boolean isSingle() {
        return true;
    }
}

