/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import ch.njol.util.Pair;
import java.lang.reflect.Array;
import org.bukkit.event.Event;

@Name(value="Parse")
@Description(value={"Parses text as a given type, or as a given pattern.", "This expression can be used in two different ways: One which parses the entire text as a single instance of a type, e.g. as a number, and one that parses the text according to a pattern.", "If the given text could not be parsed, this expression will return nothing and the <a href='#ExprParseError'>parse error</a> will be set if some information is available.", "Some notes about parsing with a pattern:", "- The pattern must be a <a href='../patterns/'>Skript pattern</a>, e.g. percent signs are used to define where to parse which types, e.g. put a %number% or %items% in the pattern if you expect a number or some items there.", "- You <i>have to</i> save the expression's value in a list variable, e.g. <code>set {parsed::*} to message parsed as \"...\"</code>.", "- The list variable will contain the parsed values from all %types% in the pattern in order. If a type was plural, e.g. %items%, the variable's value at the respective index will be a list variable, e.g. the values will be stored in {parsed::1::*}, not {parsed::1}."})
@Examples(value={"set {var} to line 1 parsed as number", "on chat:", "\tset {var::*} to message parsed as \"buying %items% for %money%\"", "\tif parse error is set:", "\t\tmessage \"%parse error%\"", "\telse if {var::*} is set:", "\t\tcancel event", "\t\tremove {var::2} from the player's balance", "\t\tgive {var::1::*} to the player"})
@Since(value="2.0")
public class ExprParse
extends SimpleExpression<Object> {
    static String lastError;
    private Expression<String> text;
    private String pattern;
    private boolean[] plurals;
    private ClassInfo<?> c;

    static {
        Skript.registerExpression(ExprParse.class, Object.class, ExpressionType.COMBINED, "%string% parsed as %*string/classinfo%");
        lastError = null;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.text = exprs[0];
        Object o = exprs[1].getSingle(null);
        if (o instanceof String) {
            this.pattern = (String)o;
            this.pattern = this.pattern.replace("\u00a6", "\\\u00a6");
            Pair<String, boolean[]> p = SkriptParser.validatePattern(this.pattern);
            if (p == null) {
                return false;
            }
            this.pattern = (String)p.first;
            this.plurals = (boolean[])p.second;
        } else {
            this.c = (ClassInfo)o;
            if (this.c.getParser() == null || !this.c.getParser().canParse(ParseContext.COMMAND)) {
                Skript.error("Text cannot be parsed as " + this.c.getName().withIndefiniteArticle());
                return false;
            }
        }
        return true;
    }

    @Override
    protected Object[] get(Event e) {
        String t = this.text.getSingle(e);
        if (t == null) {
            return null;
        }
        ParseLogHandler h = SkriptLogger.startParseLogHandler();
        try {
            if (this.c != null) {
                Object o = this.c.getParser().parse(t, ParseContext.COMMAND);
                if (o != null) {
                    Object[] one = (Object[])Array.newInstance(this.c.getC(), 1);
                    one[0] = o;
                    Object[] objectArray = one;
                    return objectArray;
                }
            } else {
                SkriptParser.ParseResult r = SkriptParser.parse(t, this.pattern);
                if (r != null) {
                    assert (this.plurals.length == r.exprs.length);
                    Object[] os = new Object[r.exprs.length];
                    int i = 0;
                    while (i < os.length) {
                        os[i] = this.plurals[i] ? r.exprs[i].getArray(null) : r.exprs[i].getSingle(null);
                        ++i;
                    }
                    Object[] objectArray = os;
                    return objectArray;
                }
            }
            lastError = h.hasError() ? h.getError().getMessage() : null;
            return null;
        }
        finally {
            h.clear();
            h.printLog();
        }
    }

    @Override
    public boolean isSingle() {
        return this.pattern != null;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.c != null ? this.c.getC() : Object[].class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.text.toString(e, debug)) + " parsed as " + (this.c != null ? this.c.toString(4) : this.pattern);
    }
}

