/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Name(value="Named Item")
@Description(value={"Directly names an item, useful for defining a named item in a script. If you want to (re)name existing items you can either use this expression or use <code>set <a href='#ExprName'>name of &lt;item&gt;</a> to &lt;text&gt;</code>."})
@Examples(value={"give a diamond sword of sharpness 100 named \"<gold>Excalibur\" to the player", "set tool of player to the player's tool named \"<gold>Wand\"", "set the name of the player's tool to \"<gold>Wand\""})
@Since(value="2.0")
public class ExprNamed
extends PropertyExpression<ItemStack, ItemStack> {
    private Expression<String> name;

    static {
        Skript.registerExpression(ExprNamed.class, ItemStack.class, ExpressionType.PROPERTY, "%itemstacks% (named|with name[s]) %string%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Skript.isRunningMinecraft(1, 4, 5)) {
            Skript.error("Item names are only available in Minecraft 1.4.5+");
            return false;
        }
        this.setExpr(exprs[0]);
        this.name = exprs[1];
        return true;
    }

    protected ItemStack[] get(Event e, ItemStack[] source) {
        String n = this.name.getSingle(e);
        if (n == null) {
            return new ItemStack[0];
        }
        ItemStack[] r = (ItemStack[])source.clone();
        int i = 0;
        while (i < r.length) {
            r[i] = source[i].clone();
            ItemMeta m = r[i].getItemMeta();
            if (m != null) {
                m.setDisplayName(n);
                r[i].setItemMeta(m);
            }
            ++i;
        }
        return r;
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.getExpr().toString(e, debug)) + " named " + this.name;
    }
}

