/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Slot;
import ch.njol.util.CollectionUtils;
import ch.njol.util.Kleenean;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Name(value="Name / Display Name")
@Description(value={"Represents a player's minecraft account name, chat display name, or playerlist name, or the custom name of an item or <a href='../classes/#livingentity'>a living entity</a>.", "The differences between the different names are:", "<ul>", "<li>name: Minecraft account name of a player (unmodifiable), or the custom name of an item or mob (modifiable).</li>", "<li>display name: The name of a player as displayed in the chat and messages, e.g. when including %player% in a message. This name can be changed freely and can include colour codes, and is shared among all plugins (e.g. chat plugins will use a changed name).</li>", "<li>tab list name: The name of a player used in the player lists that usually opens with the tab key. Please note that this is limited to 16 characters, including colour codes which are counted as 2 characters each, and that no two players can have the same tab list name at the same time.</li>", "</ul>"})
@Examples(value={"on join:", "\tplayer has permission \"name.red\"", "\tset the player's display name to \"<red>[admin]<gold>%name of player%\"", "\tset the player's tablist name to \"<green>%name of player%\"", "set the name of the player's tool to \"Legendary Sword of Awesomeness\""})
@Since(value="1.4.6 (players' name & display name), <i>unknown</i> (player list name), 2.0 (item name)")
public class ExprName
extends SimplePropertyExpression<Object, String> {
    static final int ITEMSTACK = 1;
    static final int ENTITY = 2;
    static final int PLAYER = 4;
    static final String[] types = new String[]{"slots/itemstacks", "livingentities", "players"};
    private NameType type;
    private int changeType = 0;

    static {
        NameType[] nameTypeArray = NameType.values();
        int n = nameTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NameType n3 = nameTypeArray[n2];
            ExprName.register(ExprName.class, String.class, n3.pattern, n3.getFrom());
            ++n2;
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = NameType.values()[parseResult.mark];
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public Class<String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return this.type.name;
    }

    @Override
    public String convert(Object o) {
        return this.type.get(o instanceof Slot ? ((Slot)o).getItem() : o);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE && (this.type.acceptChange & 0xFFFFFFFB) != 0 || mode == Changer.ChangeMode.RESET) {
            return new Class[0];
        }
        if (mode != Changer.ChangeMode.SET) {
            return null;
        }
        if ((this.type.acceptChange & 4) != 0 && Player.class.isAssignableFrom(this.getExpr().getReturnType())) {
            this.changeType = 4;
        } else if ((this.type.acceptChange & 1) != 0 && (this.getExpr().isSingle() && CollectionUtils.contains(this.getExpr().acceptChange(Changer.ChangeMode.SET), ItemStack.class) || Slot.class.isAssignableFrom(this.getExpr().getReturnType()))) {
            this.changeType = 1;
        } else if ((this.type.acceptChange & 2) != 0 && LivingEntity.class.isAssignableFrom(this.getExpr().getReturnType())) {
            if (this.type == NameType.NAME && Player.class.isAssignableFrom(this.getExpr().getReturnType())) {
                Skript.error("Cannot change the Minecraft name of a player. Change the 'display name of <player>' or 'tablist name of <player>' instead.");
                return null;
            }
            this.changeType = 2;
        }
        return this.changeType == 0 ? null : CollectionUtils.array(String.class);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        if (this.changeType == 1) {
            if (Slot.class.isAssignableFrom(this.getExpr().getReturnType())) {
                Slot[] slotArray = (Slot[])this.getExpr().getArray(e);
                int n = slotArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Slot s = slotArray[n2];
                    ItemStack i = s.getItem();
                    this.type.set(i, (String)delta);
                    s.setItem(i);
                    ++n2;
                }
            } else {
                Object i = this.getExpr().getSingle(e);
                if (!(i instanceof ItemStack) && !(i instanceof Slot)) {
                    return;
                }
                ItemStack is = i instanceof Slot ? ((Slot)i).getItem() : (ItemStack)i;
                this.type.set(is, (String)delta);
                if (i instanceof Slot) {
                    ((Slot)i).setItem(is);
                } else {
                    this.getExpr().change(e, i, Changer.ChangeMode.SET);
                }
            }
        } else {
            F[] FArray = this.getExpr().getArray(e);
            int n = FArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object o = FArray[n3];
                if (o instanceof LivingEntity || o instanceof Player) {
                    this.type.set(o, (String)delta);
                }
                ++n3;
            }
        }
    }

    private static abstract class NameType
    extends Enum<NameType> {
        public static final /* enum */ NameType NAME = new NameType("name", "name", 7, 3){

            @Override
            void set(Object o, String s) {
                if (o == null) {
                    return;
                }
                if (o instanceof LivingEntity) {
                    ((LivingEntity)o).setCustomName(s);
                    ((LivingEntity)o).setCustomNameVisible(s != null);
                } else if (o instanceof ItemStack) {
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    if (m != null) {
                        m.setDisplayName(s);
                        ((ItemStack)o).setItemMeta(m);
                    }
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            String get(Object o) {
                if (o == null) {
                    return null;
                }
                if (o instanceof Player) {
                    return ((Player)o).getName();
                }
                if (o instanceof LivingEntity) {
                    return ((LivingEntity)o).getCustomName();
                }
                if (o instanceof ItemStack) {
                    if (!((ItemStack)o).hasItemMeta()) {
                        return null;
                    }
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    return m == null || !m.hasDisplayName() ? null : m.getDisplayName();
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        };
        public static final /* enum */ NameType DISPLAY_NAME = new NameType("display name", "(display|nick)[ ]name", 7, 7){

            @Override
            void set(Object o, String s) {
                if (o == null) {
                    return;
                }
                if (o instanceof Player) {
                    ((Player)o).setDisplayName(s == null ? ((Player)o).getName() : String.valueOf(s) + ChatColor.RESET);
                } else if (o instanceof LivingEntity) {
                    ((LivingEntity)o).setCustomName(s);
                    ((LivingEntity)o).setCustomNameVisible(s != null);
                } else if (o instanceof ItemStack) {
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    if (m != null) {
                        m.setDisplayName(s);
                        ((ItemStack)o).setItemMeta(m);
                    }
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            String get(Object o) {
                if (o == null) {
                    return null;
                }
                if (o instanceof Player) {
                    return ((Player)o).getDisplayName();
                }
                if (o instanceof LivingEntity) {
                    return ((LivingEntity)o).getCustomName();
                }
                if (o instanceof ItemStack) {
                    if (!((ItemStack)o).hasItemMeta()) {
                        return null;
                    }
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    return m == null || !m.hasDisplayName() ? null : m.getDisplayName();
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        };
        public static final /* enum */ NameType TABLIST_NAME = new NameType("player list name", "(player|tab)[ ]list name", 4, 4){

            @Override
            void set(Object o, String s) {
                if (o == null) {
                    return;
                }
                if (o instanceof Player) {
                    try {
                        ((Player)o).setPlayerListName(s.length() > 16 ? s.substring(0, 16) : s);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            String get(Object o) {
                if (o == null) {
                    return null;
                }
                if (o instanceof Player) {
                    return ((Player)o).getPlayerListName();
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        };
        final String name;
        final String pattern;
        final int from;
        final int acceptChange;
        private static final /* synthetic */ NameType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new NameType[]{NAME, DISPLAY_NAME, TABLIST_NAME};
        }

        private NameType(String name, String pattern, int from, int change) {
            this.name = name;
            this.pattern = "(" + this.ordinal() + "\u00a6)" + pattern;
            this.from = from;
            this.acceptChange = change;
        }

        abstract void set(Object var1, String var2);

        abstract String get(Object var1);

        String getFrom() {
            String r = "";
            int i = 0;
            while (i < types.length) {
                if ((this.from & 1 << i) != 0 && (1 << i != 1 || Skript.isRunningMinecraft(1, 4, 5)) && (1 << i != 2 || Skript.isRunningMinecraft(1, 5))) {
                    if (!r.isEmpty()) {
                        r = String.valueOf(r) + "/";
                    }
                    r = String.valueOf(r) + types[i];
                }
                ++i;
            }
            return r;
        }

        public static NameType[] values() {
            NameType[] nameTypeArray = ENUM$VALUES;
            int n = nameTypeArray.length;
            NameType[] nameTypeArray2 = new NameType[n];
            System.arraycopy(ENUM$VALUES, 0, nameTypeArray2, 0, n);
            return nameTypeArray2;
        }

        public static NameType valueOf(String string) {
            return Enum.valueOf(NameType.class, string);
        }
    }
}

