/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Name(value="Items In")
@Description(value={"All items in an inventory. Useful for looping or storing in a list variable.", "Please note that the positions of the items in the inventory are not saved, only their order is preserved."})
@Examples(value={"loop all items in the player's inventory:", "\tloop-item is enchanted\tremove loop-item from the player", "set {inventory.%player%} to items in the player's inventory"})
@Since(value="2.0")
public class ExprItemsIn
extends SimpleExpression<ItemStack> {
    Expression<Inventory> invis;

    static {
        Skript.registerExpression(ExprItemsIn.class, ItemStack.class, ExpressionType.PROPERTY, "[all] items (in|of|contained in|out of) %inventories%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.invis = exprs[0];
        return true;
    }

    protected ItemStack[] get(Event e) {
        ArrayList<ItemStack> r = new ArrayList<ItemStack>();
        Inventory[] inventoryArray = this.invis.getArray(e);
        int n = inventoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Inventory invi = inventoryArray[n2];
            for (ItemStack is : invi) {
                if (is == null) continue;
                r.add(is);
            }
            ++n2;
        }
        return r.toArray(new ItemStack[r.size()]);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "items in " + this.invis.toString(e, debug);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }
}

