/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.util.Slot;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Item")
@Description(value={"The item involved in an event, e.g. in a drop, dispense, pickup or craft event."})
@Examples(value={"on dispense:", "\titem is a clock", "\tset the time to 6:00"})
@Since(value="")
public class ExprItem
extends EventValueExpression<ItemStack> {
    private EventValueExpression<Item> item;
    private EventValueExpression<Slot> slot;

    static {
        Skript.registerExpression(ExprItem.class, ItemStack.class, ExpressionType.SIMPLE, "[the] item");
    }

    public ExprItem() {
        super(ItemStack.class);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET) {
            return null;
        }
        this.item = new EventValueExpression<Item>(Item.class);
        if (this.item.init()) {
            return new Class[]{ItemType.class};
        }
        this.item = null;
        this.slot = new EventValueExpression<Slot>(Slot.class);
        if (this.slot.init()) {
            return new Class[]{ItemType.class};
        }
        this.slot = null;
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        Slot s;
        ItemType t = (ItemType)delta;
        Item i = this.item == null ? null : (Item)this.item.getSingle(e);
        Slot slot = s = this.slot == null ? null : (Slot)this.slot.getSingle(e);
        if (i == null && s == null) {
            return;
        }
        ItemStack is = i != null ? i.getItemStack() : s.getItem();
        switch (mode) {
            case SET: {
                is = t.getRandom();
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                if (!t.isOfType(is)) break;
                if (mode == Changer.ChangeMode.ADD) {
                    is = t.addTo(is);
                    break;
                }
                if (mode == Changer.ChangeMode.REMOVE) {
                    is = t.removeFrom(is);
                    break;
                }
                is = t.removeAll(is);
                break;
            }
            case DELETE: {
                is = null;
                if (i == null) break;
                i.remove();
                break;
            }
            case RESET: {
                assert (false);
                break;
            }
        }
        if (i != null) {
            i.setItemStack(is);
        } else {
            s.setItem(is);
        }
    }
}

