/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.HealthUtils;
import ch.njol.util.CollectionUtils;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

@Name(value="Health")
@Description(value={"The health of a creature, e.g. a player, mob, villager, etc. from 0 to the creature's max health, e.g. 10 for players."})
@Examples(value={"message \"You have %health% HP left.\""})
@Since(value="1.0")
public class ExprHealth
extends PropertyExpression<LivingEntity, Double> {
    static {
        ExprHealth.register(ExprHealth.class, Double.class, "health", "livingentities");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(vars[0]);
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the health of " + this.getExpr().toString(e, debug);
    }

    protected Double[] get(Event e, LivingEntity[] source) {
        return this.get(source, new Getter<Double, LivingEntity>(){

            @Override
            public Double get(LivingEntity entity) {
                return HealthUtils.getHealth(entity);
            }
        });
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        return CollectionUtils.array(Number.class);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        double d = delta == null ? 0.0 : ((Number)delta).doubleValue();
        switch (mode) {
            case SET: 
            case DELETE: {
                LivingEntity[] livingEntityArray = (LivingEntity[])this.getExpr().getArray(e);
                int n = livingEntityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LivingEntity entity = livingEntityArray[n2];
                    HealthUtils.setHealth(entity, d);
                    ++n2;
                }
                break;
            }
            case REMOVE: {
                d = -d;
            }
            case ADD: {
                LivingEntity[] livingEntityArray = (LivingEntity[])this.getExpr().getArray(e);
                int n = livingEntityArray.length;
                int n3 = 0;
                while (n3 < n) {
                    LivingEntity entity = livingEntityArray[n3];
                    HealthUtils.heal(entity, d);
                    ++n3;
                }
                break;
            }
            case RESET: {
                LivingEntity[] livingEntityArray = (LivingEntity[])this.getExpr().getArray(e);
                int n = livingEntityArray.length;
                int n4 = 0;
                while (n4 < n) {
                    LivingEntity entity = livingEntityArray[n4];
                    HealthUtils.setHealth(entity, HealthUtils.getMaxHealth(entity));
                    ++n4;
                }
                break;
            }
            case REMOVE_ALL: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public Class<Double> getReturnType() {
        return Double.class;
    }
}

