/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Slot;
import ch.njol.util.CollectionUtils;
import ch.njol.util.Math2;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Data Value")
@Description(value={"The data value of an item.", "You usually don't need this expression as you can check and set items with aliases easily, but this expression can e.g. be used to \"add 1 to data of &lt;item&gt;\", e.g. for cycling through all wool colours."})
@Examples(value={"add 1 to the data value of the clicked block"})
@Since(value="1.2")
public class ExprDurability
extends SimplePropertyExpression<Object, Short> {
    static {
        ExprDurability.register(ExprDurability.class, Short.class, "((data|damage)[s] [value[s]]|durabilit(y|ies))", "itemstacks/slots");
    }

    @Override
    public Short convert(Object o) {
        if (o instanceof Slot) {
            ItemStack i = ((Slot)o).getItem();
            return i == null ? null : Short.valueOf(i.getDurability());
        }
        return ((ItemStack)o).getDurability();
    }

    @Override
    public String getPropertyName() {
        return "data";
    }

    @Override
    public Class<Short> getReturnType() {
        return Short.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        if (Slot.class.isAssignableFrom(this.getExpr().getReturnType()) || this.getExpr().isSingle() && CollectionUtils.contains(this.getExpr().acceptChange(Changer.ChangeMode.SET), ItemStack.class)) {
            return CollectionUtils.array(Number.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        F[] os;
        int a = 0;
        if (mode != Changer.ChangeMode.DELETE) {
            a = ((Number)delta).intValue();
        }
        F[] FArray = os = this.getExpr().getArray(e);
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i;
            Object o = FArray[n2];
            ItemStack itemStack = i = o instanceof Slot ? ((Slot)o).getItem() : (ItemStack)o;
            if (i != null) {
                switch (mode) {
                    case REMOVE: {
                        a = -a;
                    }
                    case ADD: {
                        i.setDurability((short)Math2.fit(0, i.getDurability() + a, (int)i.getType().getMaxDurability()));
                        break;
                    }
                    case SET: {
                        i.setDurability((short)Math2.fit(0, a, (int)i.getType().getMaxDurability()));
                        break;
                    }
                    case DELETE: 
                    case RESET: {
                        a = 0;
                        i.setDurability((short)0);
                        break;
                    }
                    case REMOVE_ALL: {
                        assert (false);
                        break;
                    }
                }
                if (o instanceof Slot) {
                    ((Slot)o).setItem(i);
                } else {
                    this.getExpr().change(e, i, Changer.ChangeMode.SET);
                }
            }
            ++n2;
        }
    }
}

