/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Experience;
import ch.njol.util.CollectionUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.iterator.IteratorIterable;
import java.util.List;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Name(value="Drops")
@Description(value={"Only works in death events. Holds the drops of the dying creature. Drops can be prevented by removing them with \"remove ... from drops\", e.g. \"remove all pickaxes from the drops\", or \"clear drops\" if you don't want any drops at all."})
@Examples(value={"clear drops", "remove 4 planks from the drops"})
@Since(value="1.0")
public class ExprDrops
extends SimpleExpression<ItemStack> {
    private Kleenean delayed;

    static {
        Skript.registerExpression(ExprDrops.class, ItemStack.class, ExpressionType.SIMPLE, "[the] drops");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (!ScriptLoader.isCurrentEvent(EntityDeathEvent.class)) {
            Skript.error("The expression 'drops' can only be used in death events", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.delayed = isDelayed;
        return true;
    }

    protected ItemStack[] get(Event e) {
        if (!(e instanceof EntityDeathEvent)) {
            return null;
        }
        return ((EntityDeathEvent)e).getDrops().toArray(new ItemStack[0]);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET) {
            return null;
        }
        if (this.delayed.isTrue()) {
            Skript.error("Can't change the drops anymore after the event has already passed");
            return null;
        }
        return CollectionUtils.array(ItemType[].class, Inventory.class, Experience.class);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        if (!(e instanceof EntityDeathEvent)) {
            assert (false);
            return;
        }
        if (delta instanceof Experience) {
            if (mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.REMOVE && ((Experience)delta).getInternalXP() == -1) {
                ((EntityDeathEvent)e).setDroppedExp(0);
            } else {
                int xp = ((Experience)delta).getXP();
                if (mode == Changer.ChangeMode.ADD) {
                    xp += ((EntityDeathEvent)e).getDroppedExp();
                } else if (mode == Changer.ChangeMode.REMOVE) {
                    xp = ((EntityDeathEvent)e).getDroppedExp() - xp;
                }
                ((EntityDeathEvent)e).setDroppedExp(xp < 0 ? 0 : xp);
            }
        } else {
            List drops = ((EntityDeathEvent)e).getDrops();
            switch (mode) {
                case SET: {
                    drops.clear();
                }
                case ADD: {
                    if (delta instanceof Inventory) {
                        for (ItemStack is : new IteratorIterable(((Inventory)delta).iterator())) {
                            if (is == null) continue;
                            drops.add(is);
                        }
                    } else {
                        ItemType[] itemTypeArray = (ItemType[])delta;
                        int n = itemTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ItemType type = itemTypeArray[n2];
                            type.addTo(drops);
                            ++n2;
                        }
                    }
                    break;
                }
                case REMOVE: 
                case REMOVE_ALL: {
                    if (delta instanceof Inventory) {
                        for (ItemStack is : new IteratorIterable(((Inventory)delta).iterator())) {
                            if (is == null) continue;
                            if (mode == Changer.ChangeMode.REMOVE) {
                                new ItemType(is).removeFrom(drops);
                                continue;
                            }
                            new ItemType(is).removeAll(drops);
                        }
                    } else {
                        ItemType[] itemTypeArray = (ItemType[])delta;
                        int n = itemTypeArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            ItemType type = itemTypeArray[n3];
                            if (mode == Changer.ChangeMode.REMOVE) {
                                type.removeFrom(drops);
                            } else {
                                type.removeAll(drops);
                            }
                            ++n3;
                        }
                    }
                    break;
                }
                case DELETE: {
                    drops.clear();
                    break;
                }
                case RESET: {
                    assert (false);
                    break;
                }
            }
        }
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the drops";
        }
        return Classes.getDebugMessage(this.getAll(e));
    }

    @Override
    public boolean isSingle() {
        return false;
    }
}

