/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Color;
import ch.njol.util.CollectionUtils;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Colour of")
@Description(value={"The <a href='../classes/#color'>colour</a> of an item, can also be used to colour chat messages with \"&lt;%colour of ...%&gt;this text is coloured!\"."})
@Examples(value={"on click on wool:", "\tmessage \"This wool block is <%colour of block%>%colour of block%<reset>!\"", "\tset the colour of the block to black"})
@Since(value="1.2")
public class ExprColorOf
extends SimplePropertyExpression<Object, Color> {
    static {
        ExprColorOf.register(ExprColorOf.class, Color.class, "colo[u]r[s]", "itemstacks/entities");
    }

    @Override
    public Color convert(Object o) {
        if (o instanceof ItemStack || o instanceof Item) {
            ItemStack is;
            ItemStack itemStack = is = o instanceof ItemStack ? (ItemStack)o : ((Item)o).getItemStack();
            if (is.getType() == Material.WOOL) {
                return Color.byWool(is.getDurability());
            }
            if (is.getType() == Material.INK_SACK) {
                return Color.byDye(is.getDurability());
            }
        } else if (o instanceof Sheep) {
            return Color.byWoolColor(((Sheep)o).getColor());
        }
        return null;
    }

    @Override
    protected String getPropertyName() {
        return "colour";
    }

    @Override
    public Class<Color> getReturnType() {
        return Color.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.SET) {
            return null;
        }
        if (Entity.class.isAssignableFrom(this.getExpr().getReturnType())) {
            return CollectionUtils.array(Color.class);
        }
        if (!this.getExpr().isSingle()) {
            return null;
        }
        if (CollectionUtils.containsAny(this.getExpr().acceptChange(mode), ItemStack.class, ItemType.class)) {
            return CollectionUtils.array(Color.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        F[] os = this.getExpr().getArray(e);
        if (os.length == 0) {
            return;
        }
        F[] FArray = os;
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                Object o;
                block9: {
                    ItemStack is;
                    block11: {
                        block10: {
                            o = FArray[n2];
                            if (!(o instanceof ItemStack) && !(o instanceof Item)) break block9;
                            ItemStack itemStack = is = o instanceof ItemStack ? (ItemStack)o : ((Item)o).getItemStack();
                            if (is.getType() != Material.WOOL) break block10;
                            is.setDurability((short)((Color)((Object)delta)).getWool());
                            break block11;
                        }
                        if (is.getType() != Material.INK_SACK) break block12;
                        is.setDurability((short)((Color)((Object)delta)).getDye());
                    }
                    if (o instanceof ItemStack) {
                        if (CollectionUtils.contains(this.getExpr().acceptChange(mode), ItemStack.class)) {
                            this.getExpr().change(e, is, mode);
                        } else {
                            this.getExpr().change(e, new ItemType(is), mode);
                        }
                    } else {
                        ((Item)o).setItemStack(is);
                    }
                    break block12;
                }
                if (o instanceof Sheep) {
                    ((Sheep)o).setColor(((Color)((Object)delta)).getWoolColor());
                }
            }
            ++n2;
        }
    }
}

