/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.SerializableConverter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.expressions.base.WrapperExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Name(value="Block")
@Description(value={"The block involved in the event, e.g. the clicked block or the placed block.", "Can optionally include a direction as well, e.g. 'block above' or 'block in front of the player'."})
@Examples(value={"block is ore", "set block below to air", "spawn a creeper above the block", "loop blocks in radius 4:", "\tloop-block is obsidian", "\tset loop-block to water", "block is a chest:", "\tclear the inventory of the block"})
@Since(value="1.0")
public class ExprBlock
extends WrapperExpression<Block> {
    static {
        Skript.registerExpression(ExprBlock.class, Block.class, ExpressionType.SIMPLE, "[the] [event-]block");
        Skript.registerExpression(ExprBlock.class, Block.class, ExpressionType.NORMAL, "[the] block %direction% [%location%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (exprs.length <= 0) {
            this.setExpr(new EventValueExpression<Block>(Block.class));
            return ((EventValueExpression)this.getExpr()).init();
        }
        this.setExpr(new ConvertedExpression<Location, Block>(Direction.combine(exprs[0], exprs[1]), Block.class, new SerializableConverter<Location, Block>(){

            @Override
            public Block convert(Location l) {
                return l.getBlock();
            }
        }));
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return this.getExpr() instanceof EventValueExpression ? "the block" : "the block " + this.getExpr().toString(e, debug);
    }
}

