/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.Location;
import org.bukkit.entity.Player;

@Name(value="Bed")
@Description(value={"The bed location of a player, i.e. the spawn point of a player if he ever slept in a bed and the bed still exists and is unobstructed."})
@Examples(value={"bed of player exists:", "\tteleport player the the player's bed", "else:", "\tteleport the player to the world's spawn point"})
@Since(value="2.0")
public class ExprBed
extends SimplePropertyExpression<Player, Location> {
    static {
        ExprBed.register(ExprBed.class, Location.class, "bed[s] [location[s]]", "players");
    }

    @Override
    public Location convert(Player p) {
        return p.getBedSpawnLocation();
    }

    @Override
    protected String getPropertyName() {
        return "bed";
    }

    @Override
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }
}

