/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import org.bukkit.event.Event;

@Name(value="Argument")
@Description(value={"Only usable in command events. Holds the value of the nth argument given to the command, e.g. if the command \"/tell &lt;player&gt; &lt;text&gt;\" is used like \"/tell Njol Hello Njol!\" argument 1 is the player named \"Njol\" and argument 2 is \"Hello Njol!\".", "One can also use the type of the argument instead of it's index to address the argument, e.g. in the above example 'player-argument' is the same as 'argument 1'."})
@Examples(value={"give the item-argument to the player-argument", "damage the player-argument by the number-argument", "give a diamond pickaxe to the argument", "add argument 1 to argument 2", "heal the last argument"})
@Since(value="1.0")
public class ExprArgument
extends SimpleExpression<Object> {
    private Argument<?> arg;

    static {
        Skript.registerExpression(ExprArgument.class, Object.class, ExpressionType.SIMPLE, "[the] last arg[ument][s]", "[the] arg[ument][s](-| )<(\\d+)>", "[the] <(\\d*1)st|(\\d*2)nd|(\\d*3)rd|(\\d*[4-90])th> arg[ument][s]", "[the] arg[ument][s]", "[the] %*classinfo%( |-)arg[ument][( |-)<\\d+>]", "[the] arg[ument]( |-)%*classinfo%[( |-)<\\d+>]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (Commands.currentArguments == null) {
            Skript.error("The expression 'argument' can only be used within a command", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        if (Commands.currentArguments.size() == 0) {
            Skript.error("This command doesn't have any arguments", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        switch (matchedPattern) {
            case 0: {
                this.arg = Commands.currentArguments.get(Commands.currentArguments.size() - 1);
                break;
            }
            case 1: 
            case 2: {
                int i = Utils.parseInt(parser.regexes.get(0).group(1));
                if (i > Commands.currentArguments.size()) {
                    Skript.error("The command doesn't have a " + StringUtils.fancyOrderNumber(i) + " argument", ErrorQuality.SEMANTIC_ERROR);
                    return false;
                }
                this.arg = Commands.currentArguments.get(i - 1);
                break;
            }
            case 3: {
                if (Commands.currentArguments.size() == 1) {
                    this.arg = Commands.currentArguments.get(0);
                    break;
                }
                Skript.error("'argument(s)' cannot be used if the command has multiple arguments. Use 'argument 1', 'argument 2', etc. instead", ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
            case 4: 
            case 5: {
                ClassInfo c = (ClassInfo)exprs[0].getSingle(null);
                int num = parser.regexes.size() > 0 ? Utils.parseInt(parser.regexes.get(0).group()) : -1;
                int j = 1;
                for (Argument<?> a : Commands.currentArguments) {
                    if (!c.getC().isAssignableFrom(a.getType())) continue;
                    if (this.arg != null) {
                        Skript.error("There are multiple " + c + " arguments in this command", ErrorQuality.SEMANTIC_ERROR);
                        return false;
                    }
                    if (j < num) {
                        ++j;
                        continue;
                    }
                    this.arg = a;
                    if (j == num) break;
                }
                if (this.arg != null) break;
                if (num == -1 || --j == 0) {
                    Skript.error("There is no " + c + " argument in this command", ErrorQuality.SEMANTIC_ERROR);
                } else if (j == 1) {
                    Skript.error("There is only one " + c + " argument in this command", ErrorQuality.SEMANTIC_ERROR);
                } else {
                    Skript.error("There are only " + j + " " + c + " arguments in this command", ErrorQuality.SEMANTIC_ERROR);
                }
                return false;
            }
        }
        assert (this.arg != null);
        return true;
    }

    @Override
    protected Object[] get(Event e) {
        if (!(e instanceof ScriptCommandEvent)) {
            return null;
        }
        return this.arg.getCurrent(e);
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.arg.getType();
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the " + StringUtils.fancyOrderNumber(this.arg.getIndex() + 1) + " argument";
        }
        return Classes.getDebugMessage(this.getArray(e));
    }

    @Override
    public boolean isSingle() {
        return this.arg.isSingle();
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("argument");
    }
}

