/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.events.bukkit.ExperienceSpawnEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class EvtExperienceSpawn
extends SelfRegisteringSkriptEvent {
    private static Collection<Trigger> triggers;
    private static boolean registeredExecutor;
    private static final EventExecutor executor;

    static {
        Skript.registerEvent("Experience Spawn", EvtExperienceSpawn.class, ExperienceSpawnEvent.class, "[e]xp[erience] [orb] spawn", "spawn of [a[n]] [e]xp[erience] [orb]").description("Called whenever experience is about to spawn. This is a helper event for easily being able to stop xp from spawning, as all you can currently do is cancel the event.", "Please note that it's impossible to detect xp orbs spawned by plugins (including Skript) with Bukkit, thus make sure that you have no such plugins if you don't want any xp orbs to spawn. (Many plugins that only <i>change</i> the experience dropped by blocks or entities will be detected without problems though)").examples("on xp spawn:", "\tworld is \"minigame_world\"", "\tcancel event").since("2.0");
        triggers = new ArrayList<Trigger>();
        registeredExecutor = false;
        executor = new EventExecutor(){

            public void execute(Listener listener, Event e) throws EventException {
                ExperienceSpawnEvent es;
                if (e instanceof BlockExpEvent) {
                    es = new ExperienceSpawnEvent(((BlockExpEvent)e).getExpToDrop(), ((BlockExpEvent)e).getBlock().getLocation().add(0.5, 0.5, 0.5));
                } else if (e instanceof EntityDeathEvent) {
                    es = new ExperienceSpawnEvent(((EntityDeathEvent)e).getDroppedExp(), ((EntityDeathEvent)e).getEntity().getLocation());
                } else if (e instanceof ExpBottleEvent) {
                    es = new ExperienceSpawnEvent(((ExpBottleEvent)e).getExperience(), ((ExpBottleEvent)e).getEntity().getLocation());
                } else {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return;
                }
                SkriptEventHandler.logEventStart(e);
                for (Trigger t : triggers) {
                    SkriptEventHandler.logTriggerStart(t);
                    t.execute(es);
                    SkriptEventHandler.logTriggerEnd(t);
                }
                SkriptEventHandler.logEventEnd();
                if (es.isCancelled()) {
                    if (e instanceof BlockExpEvent) {
                        ((BlockExpEvent)e).setExpToDrop(0);
                    } else if (e instanceof EntityDeathEvent) {
                        ((EntityDeathEvent)e).setDroppedExp(0);
                    } else if (e instanceof ExpBottleEvent) {
                        ((ExpBottleEvent)e).setExperience(0);
                    }
                }
            }
        };
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (!Skript.isRunningMinecraft(1, 4, 5)) {
            Skript.error("The experience spawn event can only be used in Minecraft 1.4.5 and later");
            return false;
        }
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "experience spawn";
    }

    @Override
    public void register(Trigger t) {
        triggers.add(t);
        EvtExperienceSpawn.registerExecutor();
    }

    @Override
    public void unregister(Trigger t) {
        triggers.remove(t);
    }

    @Override
    public void unregisterAll() {
        triggers.clear();
    }

    private static final void registerExecutor() {
        if (registeredExecutor) {
            return;
        }
        Class[] classArray = new Class[]{BlockExpEvent.class, EntityDeathEvent.class, ExpBottleEvent.class};
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            Bukkit.getPluginManager().registerEvent(c, new Listener(){}, SkriptConfig.defaultEventPriority.value(), executor, (Plugin)Skript.getInstance(), true);
            ++n2;
        }
    }
}

