/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.HealthUtils;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class EvtDamage
extends SkriptEvent {
    private Literal<EntityData<?>> types;

    static {
        Skript.registerEvent("Damage", EvtDamage.class, EntityDamageEvent.class, "damag(e|ing) [of %entitydata%]").description("Called when an entity receives damage, e.g. by an attack from another entity, lava, fire, drowning, fall, suffocation, etc.").examples("on damage", "on damage of a player").since("1.0");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.types = args[0];
        return true;
    }

    @Override
    public boolean check(Event evt) {
        EntityDamageEvent e = (EntityDamageEvent)evt;
        if (!this.checkType(e.getEntity())) {
            return false;
        }
        if (e instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)e).getDamager() instanceof EnderDragon && ((EntityDamageByEntityEvent)e).getEntity() instanceof EnderDragon) {
            return false;
        }
        return EvtDamage.checkDamage(e);
    }

    private boolean checkType(Entity e) {
        if (this.types == null) {
            return true;
        }
        EntityData<?>[] entityDataArray = this.types.getAll();
        int n = entityDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityData<?> d = entityDataArray[n2];
            if (d.isInstance(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "damage" + (this.types == null ? "" : " of " + this.types.toString(e, debug));
    }

    private static boolean checkDamage(EntityDamageEvent e) {
        if (!(e.getEntity() instanceof LivingEntity)) {
            return true;
        }
        LivingEntity en = (LivingEntity)e.getEntity();
        return !(HealthUtils.getHealth(en) <= 0.0);
    }
}

