/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Wolf;

public class WolfData
extends EntityData<Wolf> {
    private int angry = 0;
    private int tamed = 0;

    static {
        EntityData.register(WolfData.class, "wolf", Wolf.class, "angry wolf", "wolf", "peaceful wolf", "wild wolf", "tamed wolf");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern <= 2) {
            this.angry = matchedPattern - 1;
        } else {
            this.tamed = matchedPattern == 3 ? -1 : 1;
        }
        return true;
    }

    @Override
    protected boolean init(Class<? extends Wolf> c, Wolf e) {
        int n = e == null ? 0 : (this.angry = e.isAngry() ? 1 : -1);
        this.tamed = e == null ? 0 : (e.isTamed() ? 1 : -1);
        return true;
    }

    @Override
    public void set(Wolf entity) {
        if (this.angry != 0) {
            entity.setAngry(this.angry == 1);
        }
        if (this.tamed != 0) {
            entity.setTamed(this.tamed == 1);
        }
    }

    @Override
    public boolean match(Wolf entity) {
        return !(this.angry != 0 && entity.isAngry() != (this.angry == 1) || this.tamed != 0 && entity.isTamed() != (this.tamed == 1));
    }

    @Override
    public Class<Wolf> getType() {
        return Wolf.class;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.angry;
        result = 31 * result + this.tamed;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WolfData)) {
            return false;
        }
        WolfData other = (WolfData)obj;
        if (this.angry != other.angry) {
            return false;
        }
        return this.tamed == other.tamed;
    }

    @Override
    public String serialize() {
        return String.valueOf(this.angry) + "|" + this.tamed;
    }

    @Override
    protected boolean deserialize(String s) {
        String[] split = s.split("\\|");
        if (split.length != 2) {
            return false;
        }
        try {
            this.angry = Integer.parseInt(split[0]);
            this.tamed = Integer.parseInt(split[1]);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof WolfData) {
            return !(this.angry != 0 && ((WolfData)e).angry != this.angry || this.tamed != 0 && ((WolfData)e).tamed != this.tamed);
        }
        return false;
    }

    @Override
    public EntityData getSuperType() {
        return new WolfData();
    }
}

