/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.CollectionUtils;
import org.bukkit.Location;
import org.bukkit.entity.Villager;

public class VillagerData
extends EntityData<Villager> {
    private Villager.Profession profession = null;

    static {
        VillagerData.register(VillagerData.class, "villager", Villager.class, "villager", "farmer", "librarian", "priest", "blacksmith", "butcher");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern > 0) {
            this.profession = Villager.Profession.getProfession((int)(matchedPattern - 1));
        }
        return true;
    }

    @Override
    protected boolean init(Class<? extends Villager> c, Villager e) {
        this.profession = e == null ? null : e.getProfession();
        return true;
    }

    @Override
    public void set(Villager entity) {
        if (this.profession != null) {
            entity.setProfession(this.profession);
        }
    }

    @Override
    public Villager spawn(Location loc) {
        Villager v = (Villager)super.spawn(loc);
        if (this.profession == null) {
            v.setProfession(CollectionUtils.random(Villager.Profession.values()));
        }
        return v;
    }

    @Override
    protected boolean match(Villager entity) {
        return this.profession == null || entity.getProfession() == this.profession;
    }

    @Override
    public Class<? extends Villager> getType() {
        return Villager.class;
    }

    @Override
    public int hashCode() {
        return this.profession == null ? 0 : this.profession.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VillagerData)) {
            return false;
        }
        VillagerData other = (VillagerData)obj;
        return this.profession == other.profession;
    }

    @Override
    public String serialize() {
        return this.profession == null ? "" : this.profession.name();
    }

    @Override
    protected boolean deserialize(String s) {
        if (s.isEmpty()) {
            return true;
        }
        try {
            this.profession = Villager.Profession.valueOf((String)s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof VillagerData) {
            return this.profession == null || ((VillagerData)e).profession == this.profession;
        }
        return false;
    }

    @Override
    public EntityData getSuperType() {
        return new VillagerData();
    }
}

