/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Skeleton;

public class SkeletonData
extends EntityData<Skeleton> {
    private static final boolean hasWither = Skript.isRunningMinecraft(1, 4);
    private boolean wither;

    static {
        if (hasWither) {
            SkeletonData.register(SkeletonData.class, "skeleton", Skeleton.class, "skeleton", "wither skeleton");
        } else {
            SkeletonData.register(SkeletonData.class, "skeleton", Skeleton.class, "skeleton");
        }
    }

    public boolean isWither() {
        return this.wither;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.wither = matchedPattern == 1;
        return true;
    }

    @Override
    protected boolean init(Class<? extends Skeleton> c, Skeleton e) {
        this.wither = e == null || !hasWither ? false : e.getSkeletonType() == Skeleton.SkeletonType.WITHER;
        return true;
    }

    @Override
    public String serialize() {
        return this.wither ? "1" : "0";
    }

    @Override
    protected boolean deserialize(String s) {
        if (s.equals("1")) {
            this.wither = true;
        } else if (s.equals("0")) {
            this.wither = false;
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void set(Skeleton entity) {
        if (hasWither) {
            entity.setSkeletonType(this.wither ? Skeleton.SkeletonType.WITHER : Skeleton.SkeletonType.NORMAL);
        }
    }

    @Override
    protected boolean match(Skeleton entity) {
        return hasWither ? entity.getSkeletonType() == Skeleton.SkeletonType.WITHER == this.wither : true;
    }

    @Override
    public Class<? extends Skeleton> getType() {
        return Skeleton.class;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkeletonData)) {
            return false;
        }
        SkeletonData other = (SkeletonData)obj;
        return other.wither == this.wither;
    }

    @Override
    public int hashCode() {
        return this.wither ? 1 : 0;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof SkeletonData) {
            return ((SkeletonData)e).wither == this.wither;
        }
        return false;
    }

    @Override
    public EntityData getSuperType() {
        return this;
    }
}

