/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Boat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Painting;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Zombie;

public class SimpleEntityData
extends EntityData<Entity> {
    private static final List<SimpleEntityDataInfo> types = new ArrayList<SimpleEntityDataInfo>();
    private SimpleEntityDataInfo info;

    static {
        types.add(new SimpleEntityDataInfo("arrow", Arrow.class));
        types.add(new SimpleEntityDataInfo("boat", Boat.class));
        types.add(new SimpleEntityDataInfo("blaze", Blaze.class));
        types.add(new SimpleEntityDataInfo("chicken", Chicken.class));
        types.add(new SimpleEntityDataInfo("cow", Cow.class));
        types.add(new SimpleEntityDataInfo("cave spider", CaveSpider.class));
        types.add(new SimpleEntityDataInfo("egg", Egg.class));
        types.add(new SimpleEntityDataInfo("ender crystal", EnderCrystal.class));
        types.add(new SimpleEntityDataInfo("ender dragon", EnderDragon.class));
        types.add(new SimpleEntityDataInfo("ender pearl", EnderPearl.class));
        types.add(new SimpleEntityDataInfo("small fireball", SmallFireball.class));
        types.add(new SimpleEntityDataInfo("fireball", Fireball.class));
        types.add(new SimpleEntityDataInfo("fish", Fish.class));
        types.add(new SimpleEntityDataInfo("ghast", Ghast.class));
        types.add(new SimpleEntityDataInfo("giant", Giant.class));
        types.add(new SimpleEntityDataInfo("iron golem", IronGolem.class));
        types.add(new SimpleEntityDataInfo("dropped item", Item.class));
        types.add(new SimpleEntityDataInfo("magma cube", MagmaCube.class));
        types.add(new SimpleEntityDataInfo("mooshroom", MushroomCow.class));
        types.add(new SimpleEntityDataInfo("painting", Painting.class));
        types.add(new SimpleEntityDataInfo("zombie pigman", PigZombie.class));
        types.add(new SimpleEntityDataInfo("silverfish", Silverfish.class));
        types.add(new SimpleEntityDataInfo("slime", Slime.class));
        types.add(new SimpleEntityDataInfo("snowball", Snowball.class));
        types.add(new SimpleEntityDataInfo("snow golem", Snowman.class));
        types.add(new SimpleEntityDataInfo("spider", Spider.class));
        types.add(new SimpleEntityDataInfo("squid", Squid.class));
        types.add(new SimpleEntityDataInfo("bottle of enchanting", ThrownExpBottle.class));
        types.add(new SimpleEntityDataInfo("thrown potion", ThrownPotion.class));
        types.add(new SimpleEntityDataInfo("tnt", TNTPrimed.class));
        types.add(new SimpleEntityDataInfo("zombie", Zombie.class));
        if (Skript.isRunningMinecraft(1, 4)) {
            types.add(new SimpleEntityDataInfo("item frame", ItemFrame.class));
            types.add(new SimpleEntityDataInfo("bat", Bat.class));
            types.add(new SimpleEntityDataInfo("witch", Witch.class));
            types.add(new SimpleEntityDataInfo("wither", Wither.class));
            types.add(new SimpleEntityDataInfo("wither skull", WitherSkull.class));
        }
        if (Skript.isRunningMinecraft(1, 4, 6)) {
            types.add(new SimpleEntityDataInfo("firework", Firework.class));
        }
        if (Skript.isRunningMinecraft(1, 6)) {
            types.add(new SimpleEntityDataInfo("horse", Horse.class));
        }
        types.add(new SimpleEntityDataInfo("human", HumanEntity.class, true));
        types.add(new SimpleEntityDataInfo("creature", Creature.class, true));
        types.add(new SimpleEntityDataInfo("projectile", Projectile.class, true));
        types.add(new SimpleEntityDataInfo("living entity", LivingEntity.class, true));
        types.add(new SimpleEntityDataInfo("entity", Entity.class, true));
        types.add(new SimpleEntityDataInfo("any fireball", Fireball.class, true));
        String[] codeNames = new String[types.size()];
        int i = 0;
        for (SimpleEntityDataInfo info : types) {
            codeNames[i++] = info.codeName;
        }
        EntityData.register(SimpleEntityData.class, "simple", Entity.class, codeNames);
    }

    public SimpleEntityData() {
        this(Entity.class);
    }

    public SimpleEntityData(Class<? extends Entity> c) {
        assert (c != null && c.isInterface()) : c;
        ((EntityData)this).info = SimpleEntityData.getInfo(this.getClass());
        int i = 0;
        for (SimpleEntityDataInfo info : types) {
            if (info.c.isAssignableFrom(c)) {
                this.info = info;
                this.matchedPattern = i;
                return;
            }
            ++i;
        }
        assert (false);
    }

    public SimpleEntityData(Entity e) {
        ((EntityData)this).info = SimpleEntityData.getInfo(this.getClass());
        int i = 0;
        for (SimpleEntityDataInfo info : types) {
            if (info.c.isInstance(e)) {
                this.info = info;
                this.matchedPattern = i;
                return;
            }
            ++i;
        }
        assert (false);
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.info = types.get(matchedPattern);
        return true;
    }

    @Override
    protected boolean init(Class<? extends Entity> c, Entity e) {
        assert (false);
        return false;
    }

    @Override
    public void set(Entity entity) {
    }

    @Override
    public boolean match(Entity e) {
        if (this.info.isSupertype) {
            return this.info.c.isInstance(e);
        }
        for (SimpleEntityDataInfo info : types) {
            if (!info.c.isInstance(e)) continue;
            return this.info.c == info.c;
        }
        assert (false);
        return false;
    }

    @Override
    public Class<? extends Entity> getType() {
        return this.info.c;
    }

    @Override
    public int hashCode() {
        return this.info.c.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleEntityData)) {
            return false;
        }
        SimpleEntityData other = (SimpleEntityData)obj;
        return this.info.c == other.info.c;
    }

    @Override
    public String serialize() {
        return this.info.c.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean deserialize(String s) {
        try {
            SimpleEntityDataInfo i;
            Class<?> c = Class.forName(s);
            Iterator<SimpleEntityDataInfo> iterator = types.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                i = iterator.next();
            } while (i.c != c);
            this.info = i;
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        return this.info.c == e.getType() || this.info.isSupertype && this.info.c.isAssignableFrom(e.getType());
    }

    @Override
    public EntityData getSuperType() {
        return this;
    }

    private static final class SimpleEntityDataInfo {
        final String codeName;
        final Class<? extends Entity> c;
        final boolean isSupertype;

        SimpleEntityDataInfo(String codeName, Class<? extends Entity> c) {
            this(codeName, c, false);
        }

        SimpleEntityDataInfo(String codeName, Class<? extends Entity> c, boolean isSupertype) {
            this.codeName = codeName;
            this.c = c;
            this.isSupertype = isSupertype;
        }
    }
}

