/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.StorageMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;

public class MinecartData
extends EntityData<Minecart> {
    private MinecartType type = MinecartType.ANY;

    static {
        MinecartData.register(MinecartData.class, "minecart", Minecart.class, MinecartType.codeNames);
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.type = MinecartType.values()[matchedPattern];
        return true;
    }

    @Override
    protected boolean init(Class<? extends Minecart> c, Minecart e) {
        MinecartType[] ts = MinecartType.values();
        int i = ts.length - 1;
        while (i >= 0) {
            if (e == null ? ts[i].c.isAssignableFrom(c) : ts[i].c.isInstance(e)) {
                this.type = ts[i];
                return true;
            }
            --i;
        }
        assert (false);
        return false;
    }

    @Override
    public void set(Minecart entity) {
    }

    @Override
    public boolean match(Minecart entity) {
        if (this.type == MinecartType.NORMAL && this.type.c == Minecart.class) {
            return !(entity instanceof org.bukkit.entity.PoweredMinecart) && !(entity instanceof StorageMinecart);
        }
        return this.type.c.isInstance(entity);
    }

    @Override
    public Class<? extends Minecart> getType() {
        return this.type.c;
    }

    @Override
    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MinecartData)) {
            return false;
        }
        MinecartData other = (MinecartData)obj;
        return this.type == other.type;
    }

    @Override
    public String serialize() {
        return this.type.name();
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            this.type = MinecartType.valueOf(s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof MinecartData) {
            return this.type == MinecartType.ANY || ((MinecartData)e).type == this.type;
        }
        return false;
    }

    @Override
    public EntityData getSuperType() {
        return new MinecartData();
    }

    private static enum MinecartType {
        ANY(Minecart.class, "minecart"),
        NORMAL(Skript.isRunningMinecraft(1, 5) ? RideableMinecart.class : Minecart.class, "regular minecart"),
        STORAGE(Skript.isRunningMinecraft(1, 5) ? org.bukkit.entity.minecart.StorageMinecart.class : StorageMinecart.class, "storage minecart"),
        POWERED(Skript.isRunningMinecraft(1, 5) ? PoweredMinecart.class : org.bukkit.entity.PoweredMinecart.class, "powered minecart"),
        HOPPER(Skript.isRunningMinecraft(1, 5) ? HopperMinecart.class : null, "hopper minecart"),
        EXPLOSIVE(Skript.isRunningMinecraft(1, 5) ? ExplosiveMinecart.class : null, "explosive minecart"),
        SPAWNER(Skript.isRunningMinecraft(1, 5) ? SpawnerMinecart.class : null, "spawner minecart");

        final Class<? extends Minecart> c;
        private final String codeName;
        public static String[] codeNames;

        static {
            codeNames = new String[MinecartType.values().length - (Skript.isRunningMinecraft(1, 5) ? 0 : 3)];
            int i = 0;
            while (i < codeNames.length) {
                MinecartType.codeNames[i] = MinecartType.values()[i].codeName;
                ++i;
            }
        }

        private MinecartType(Class<? extends Minecart> c, String codeName) {
            this.c = c;
            this.codeName = codeName;
        }

        public String toString() {
            return this.codeName;
        }
    }
}

