/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Creeper;

public class CreeperData
extends EntityData<Creeper> {
    private int powered = 0;

    static {
        EntityData.register(CreeperData.class, "creeper", Creeper.class, "unpowered creeper", "creeper", "powered creeper");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.powered = matchedPattern - 1;
        return true;
    }

    @Override
    protected boolean init(Class<? extends Creeper> c, Creeper e) {
        this.powered = e == null ? 0 : (e.isPowered() ? 1 : -1);
        return true;
    }

    @Override
    public void set(Creeper c) {
        if (this.powered != 0) {
            c.setPowered(this.powered == 1);
        }
    }

    @Override
    public boolean match(Creeper entity) {
        return this.powered == 0 || entity.isPowered() == (this.powered == 1);
    }

    @Override
    public Class<Creeper> getType() {
        return Creeper.class;
    }

    @Override
    public int hashCode() {
        return this.powered;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreeperData)) {
            return false;
        }
        CreeperData other = (CreeperData)obj;
        return this.powered == other.powered;
    }

    @Override
    public String serialize() {
        return "" + this.powered;
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            this.powered = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof CreeperData) {
            return this.powered == 0 || ((CreeperData)e).powered == this.powered;
        }
        return false;
    }

    @Override
    public EntityData getSuperType() {
        return new CreeperData();
    }
}

