/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerRespawnEvent;

@Name(value="Teleport")
@Description(value={"Teleport an entity to a specific location."})
@Examples(value={"teleport the player to {homes.%player%}", "teleport the attacker to the victim"})
@Since(value="1.0")
public class EffTeleport
extends Effect {
    private Expression<Entity> entities;
    private Expression<Location> location;

    static {
        Skript.registerEffect(EffTeleport.class, "teleport %entities% (to|%direction%) %location%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.entities = exprs[0];
        this.location = Direction.combine(exprs[1], exprs[2]);
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "teleport " + this.entities.toString(e, debug) + " to " + this.location.toString(e, debug);
    }

    @Override
    protected void execute(Event e) {
        Block on;
        Location to = this.location.getSingle(e);
        if (to == null) {
            return;
        }
        if (Math.abs(to.getX() - (double)to.getBlockX() - 0.5) < 1.0E-10 && Math.abs(to.getZ() - (double)to.getBlockZ() - 0.5) < 1.0E-10 && (on = to.getBlock().getRelative(BlockFace.DOWN)).getType() != Material.AIR) {
            to = to.clone();
            to.setY((double)on.getY() + Utils.getBlockHeight(on.getTypeId(), on.getData()));
        }
        if (e instanceof PlayerRespawnEvent && this.entities.isDefault() && !Delay.isDelayed(e)) {
            ((PlayerRespawnEvent)e).setRespawnLocation(to);
            return;
        }
        Entity[] entityArray = this.entities.getArray(e);
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (EffTeleport.ignoreDirection(to.getYaw(), to.getPitch())) {
                Location loc = to.clone();
                loc.setPitch(entity.getLocation().getPitch());
                loc.setYaw(entity.getLocation().getYaw());
                loc.getChunk().load();
                entity.teleport(loc);
            } else {
                to.getChunk().load();
                entity.teleport(to);
            }
            ++n2;
        }
    }

    private static final boolean ignoreDirection(float yaw, float pitch) {
        return (pitch == 0.0f || (double)Math.abs(pitch - 90.0f) < 1.0E-10 || (double)Math.abs(pitch + 90.0f) < 1.0E-10) && (yaw == 0.0f || Math.abs(Math.sin(Math.toRadians(yaw))) < 1.0E-10 || Math.abs(Math.cos(Math.toRadians(yaw))) < 1.0E-10);
    }
}

