/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.CollectionUtils;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;

@Name(value="Replace")
@Description(value={"Replaces all occurrences of a given text with another text. Please note that you can only change variables and a few expressions, e.g. a <a href='../expressions/#ExprMessage'>message</a> or a line of a sign."})
@Examples(value={"replace \"<item>\" in {textvar} with \"%item%\"", "replace every \"&\" with \"\u00a7\" in line 1", "# The following acts as a simple chat censor, but it will e.g. censor mass, hassle, assassin, etc. as well:", "on chat:", "\treplace all \"fuck\", \"bitch\" and \"ass\" with \"****\" in the message"})
@Since(value="2.0")
public class EffReplace
extends Effect {
    private Expression<String> haystack;
    private Expression<String> needles;
    private Expression<String> replacement;

    static {
        Skript.registerEffect(EffReplace.class, "replace (all|every|) %strings% in %string% with %string%", "replace (all|every|) %strings% with %string% in %string%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.haystack = exprs[1 + matchedPattern];
        if (!CollectionUtils.containsSuperclass(this.haystack.acceptChange(Changer.ChangeMode.SET), String.class)) {
            Skript.error(this.haystack + " cannot be changed and can thus not have parts replaced.");
            return false;
        }
        this.needles = exprs[0];
        this.replacement = exprs[2 - matchedPattern];
        return true;
    }

    @Override
    protected void execute(Event e) {
        String h = this.haystack.getSingle(e);
        String[] ns = this.needles.getAll(e);
        String r = this.replacement.getSingle(e);
        if (h == null || ns.length == 0 || r == null) {
            return;
        }
        String[] stringArray = ns;
        int n = ns.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            h = h.replace(n3, r);
            ++n2;
        }
        this.haystack.change(e, h, Changer.ChangeMode.SET);
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "replace " + this.needles.toString(e, debug) + " in " + this.haystack.toString(e, debug) + " with " + this.replacement.toString(e, debug);
    }
}

