/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;

@Name(value="Open Inventory")
@Description(value={"Opens an inventory to a player. The player can then access and modify the inventory as if it was a chest that he just opened.", "Please note that currently 'show' and 'open' have the same effect, but 'show' will eventually show an unmodifiable view of the inventory in the future."})
@Examples(value={"show the victim's inventory to the player", "open the player's inventory for the player"})
@Since(value="2.0")
public class EffOpenInventory
extends Effect {
    private Expression<Inventory> invi;
    private Expression<Player> players;

    static {
        Skript.registerEffect(EffOpenInventory.class, "(0\u00a6open|1\u00a6show) %inventory% (to|for) %players%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (parseResult.mark == 1) {
            Skript.warning("Using 'show' inventory instead of 'open' is not recommended as it will eventually show an unmodifiable view of the inventory in the future.");
        }
        this.invi = exprs[0];
        this.players = exprs[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Inventory i = this.invi.getSingle(e);
        if (i == null) {
            return;
        }
        Player[] playerArray = this.players.getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            p.openInventory(i);
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "open " + this.invi.toString(e, debug) + " to " + this.players.toString(e, debug);
    }
}

