/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

@Name(value="Message")
@Description(value={"Sends a message to the given player."})
@Examples(value={"message \"A wild %player% appeared!\"", "message \"This message is a distraction. Mwahaha!\"", "send \"Your kill streak is %{kill streak.%player%}%.\" to player", "if the targeted entity exists:", "\tmessage \"You're currently looking at a %type of the targeted entity%!\""})
@Since(value="1.0")
public class EffMessage
extends Effect {
    private Expression<String> messages;
    private Expression<CommandSender> recipients;

    static {
        Skript.registerEffect(EffMessage.class, "(message|send [message]) %strings% [to %commandsenders%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.messages = exprs[0];
        this.recipients = exprs[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        String[] stringArray = this.messages.getArray(e);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            CommandSender[] commandSenderArray = this.recipients.getArray(e);
            int n3 = commandSenderArray.length;
            int n4 = 0;
            while (n4 < n3) {
                CommandSender s = commandSenderArray[n4];
                s.sendMessage(message);
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "send " + this.messages.toString(e, debug) + " to " + this.recipients.toString(e, debug);
    }
}

