/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

@Name(value="Ignite/Extinguish")
@Description(value={"Lights entities on fire or extinguishes them."})
@Examples(value={"ignite the player", "extinguish the player"})
@Since(value="1.4")
public class EffIgnite
extends Effect {
    private static final int DEFAULT_DURATION = 160;
    private Expression<Entity> entities;
    private boolean ignite;
    private Expression<Timespan> duration = null;

    static {
        Skript.registerEffect(EffIgnite.class, "(ignite|set fire to) %entities% [for %-timespan%]", "(set|light) %entities% on fire [for %-timespan%]", "extinguish %entities%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        boolean bl = this.ignite = exprs.length > 1;
        if (this.ignite) {
            this.duration = exprs[1];
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        int d;
        if (this.duration != null) {
            Timespan t = this.duration.getSingle(e);
            if (t == null) {
                return;
            }
            d = t.getTicks();
        } else {
            d = this.ignite ? 160 : 0;
        }
        Entity[] entityArray = this.entities.getArray(e);
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Entity en = entityArray[n2];
            if (e instanceof EntityDamageEvent && ((EntityDamageEvent)e).getEntity() == en && !Delay.isDelayed(e)) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        en.setFireTicks(d);
                    }
                });
            } else {
                if (e instanceof EntityCombustEvent && ((EntityCombustEvent)e).getEntity() == en && !Delay.isDelayed(e)) {
                    ((EntityCombustEvent)e).setCancelled(true);
                }
                en.setFireTicks(d);
            }
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return this.ignite ? "set " + this.entities.toString(e, debug) + " on fire for " + (this.duration == null ? Timespan.fromTicks(160).toString() : this.duration.toString(e, debug)) : "extinguish " + this.entities.toString(e, debug);
    }
}

