/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Explosion")
@Description(value={"Creates an explosion of a given force. The Minecraft Wiki has an <a href='http://www.minecraftwiki.net/wiki/Explosion'>article on explosions</a> which lists the explosion forces of TNT, creepers, etc.", "Hint: use a force of 0 to create a fake explosion that does no damage whatsoever, or use the explosion effect introduced in Skript 2.0.", "Starting with Bukkit 1.4.5 and Skript 2.0 you can use safe explosions which will damage entities but won't destroy any blocks."})
@Examples(value={"create an explosion of force 10 at the player", "create an explosion of force 0 at the victim"})
@Since(value="1.0")
public class EffExplosion
extends Effect {
    private Expression<Number> force;
    private Expression<Location> locations;
    private boolean blockDamage;

    static {
        Skript.registerEffect(EffExplosion.class, "[(create|make)] [an] explosion (of|with) (force|strength|power) %number% [%directions% %locations%]", "[(create|make)] [a] safe explosion (of|with) (force|strength|power) %number% [%directions% %locations%]", "[(create|make)] [a] fake explosion [%directions% %locations%]", "[(create|make)] [an] explosion[ ]effect [%directions% %locations%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.force = matchedPattern <= 1 ? exprs[0] : null;
        boolean bl = this.blockDamage = matchedPattern != 1;
        if (!this.blockDamage && !Skript.isRunningMinecraft(1, 4, 5)) {
            Skript.error("Explosions which do not destroy blocks are only available in Bukkit 1.4.5+");
            return false;
        }
        this.locations = Direction.combine(exprs[exprs.length - 2], exprs[exprs.length - 1]);
        return true;
    }

    @Override
    public void execute(Event e) {
        Integer power;
        Number number = power = this.force == null ? (Number)0 : (Number)this.force.getSingle(e);
        if (power == null) {
            return;
        }
        Location[] locationArray = this.locations.getArray(e);
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location l = locationArray[n2];
            if (!this.blockDamage) {
                l.getWorld().createExplosion(l.getX(), l.getY(), l.getZ(), ((Number)power).floatValue(), false, false);
            } else {
                l.getWorld().createExplosion(l, ((Number)power).floatValue());
            }
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "create explosion of force " + this.force.toString(e, debug) + " " + this.locations.toString(e, debug);
    }
}

