/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Testable;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Equip")
@Description(value={"Equips a player with some given armor. This will replace any armor that the player is wearing."})
@Examples(value={"equip player with diamond helmet", "equip player with all diamond armor"})
@Since(value="1.0")
public class EffEquip
extends Effect
implements Testable {
    private Expression<Player> players;
    private Expression<ItemType> types;

    static {
        Skript.registerEffect(EffEquip.class, "equip [%players%] with %itemtypes%", "make %players% wear %itemtypes%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.players = vars[0];
        this.types = vars[1];
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "equip " + this.players.toString(e, debug) + " with " + this.types.toString(e, debug);
    }

    @Override
    protected void execute(Event e) {
        ItemType[] ts = this.types.getArray(e);
        Player[] playerArray = this.players.getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            ItemType[] itemTypeArray = ts;
            int n3 = ts.length;
            int n4 = 0;
            while (n4 < n3) {
                ItemType t = itemTypeArray[n4];
                block8: for (ItemStack item : t.getBlock().getAll()) {
                    switch (item.getType()) {
                        case LEATHER_BOOTS: 
                        case CHAINMAIL_BOOTS: 
                        case IRON_BOOTS: 
                        case DIAMOND_BOOTS: 
                        case GOLD_BOOTS: {
                            p.getInventory().setBoots(item);
                            break;
                        }
                        case LEATHER_LEGGINGS: 
                        case CHAINMAIL_LEGGINGS: 
                        case IRON_LEGGINGS: 
                        case DIAMOND_LEGGINGS: 
                        case GOLD_LEGGINGS: {
                            p.getInventory().setLeggings(item);
                            break;
                        }
                        case LEATHER_CHESTPLATE: 
                        case CHAINMAIL_CHESTPLATE: 
                        case IRON_CHESTPLATE: 
                        case DIAMOND_CHESTPLATE: 
                        case GOLD_CHESTPLATE: {
                            p.getInventory().setChestplate(item);
                            break;
                        }
                        default: {
                            if (!item.getType().isBlock() && item.getTypeId() != 397) continue block8;
                        }
                        case LEATHER_HELMET: 
                        case CHAINMAIL_HELMET: 
                        case IRON_HELMET: 
                        case DIAMOND_HELMET: 
                        case GOLD_HELMET: {
                            p.getInventory().setHelmet(item);
                        }
                    }
                }
                ++n4;
            }
            p.updateInventory();
            ++n2;
        }
    }

    @Override
    public boolean test(Event e) {
        return false;
    }
}

