/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.Slot;
import ch.njol.util.CollectionUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

@Name(value="Colour Armour")
@Description(value={"Colours leather armour in a given <a href='../classes/#color'>colour</a>. You can also use RGB codes if you feel limited with the 16 default colours. RGB codes are three numbers from 0 to 255 in the order <code>(red, green, blue)</code>, where <code>(0,0,0)</code> is black and <code>(255,255,255)</code> is white."})
@Examples(value={"dye player's helmet blue", "colour the player's tool red"})
@Since(value="2.0")
public class EffColorArmor
extends Effect {
    private Expression<?> items;
    private Expression<Color> color;
    private Expression<Number> red;
    private Expression<Number> green;
    private Expression<Number> blue;

    static {
        Skript.registerEffect(EffColorArmor.class, "(dye|colo[u]r|paint) %slots/itemstack% %color%", "(dye|colo[u]r|paint) %slots/itemstack% \\(%number%, %number%, %number%\\)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.items = exprs[0];
        if (!Slot.class.isAssignableFrom(this.items.getReturnType()) && !CollectionUtils.containsSuperclass(this.items.acceptChange(Changer.ChangeMode.SET), ItemStack.class)) {
            Skript.error(this.items + " cannot be coloured as it cannot be changed at all.");
            return false;
        }
        if (matchedPattern == 0) {
            this.color = exprs[1];
        } else {
            this.red = exprs[1];
            this.green = exprs[2];
            this.blue = exprs[3];
        }
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "dye " + this.items.toString(e, debug) + " " + (this.color != null ? this.color.toString(e, debug) : "(" + this.red.toString(e, debug) + "," + this.green.toString(e, debug) + "," + this.blue.toString(e, debug) + ")");
    }

    @Override
    protected void execute(Event e) {
        org.bukkit.Color c;
        if (this.color != null) {
            Color cl = this.color.getSingle(e);
            if (cl == null) {
                return;
            }
            c = cl.getBukkitColor();
        } else {
            Number r = this.red.getSingle(e);
            Number g = this.green.getSingle(e);
            Number b = this.blue.getSingle(e);
            if (r == null || g == null || b == null) {
                return;
            }
            c = org.bukkit.Color.fromRGB((int)Math2.fit(0, r.intValue(), 255), (int)Math2.fit(0, g.intValue(), 255), (int)Math2.fit(0, b.intValue(), 255));
        }
        ?[] objArray = this.items.getArray(e);
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i;
            Object o = objArray[n2];
            ItemStack itemStack = i = o instanceof Slot ? ((Slot)o).getItem() : (ItemStack)o;
            if (i.getType() == Material.LEATHER_BOOTS || i.getType() == Material.LEATHER_CHESTPLATE || i.getType() == Material.LEATHER_HELMET || i.getType() == Material.LEATHER_LEGGINGS) {
                LeatherArmorMeta m = (LeatherArmorMeta)i.getItemMeta();
                m.setColor(c);
                i.setItemMeta((ItemMeta)m);
            }
            if (!(o instanceof Slot)) {
                this.items.change(e, i, Changer.ChangeMode.SET);
                return;
            }
            ((Slot)o).setItem(i);
            ++n2;
        }
    }
}

