/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.event.Event;

@Name(value="Change: Set/Add/Remove/Delete/Reset")
@Description(value={"A very general effect that can change many <a href='../expressions'>expressions</a>. Many expressions can only be set and/or deleted, while some can have things added to or removed from them."})
@Examples(value={"# set:", "Set the player's display name to \"<red>%name of player%\"", "set the block above the victim to lava", "# add:", "add 2 to the player's health # preferably use '<a href='#heal'>heal</a>' for this", "add argument to {blacklist::*}", "give a diamond pickaxe of efficiency 5 to the player", "increase the data value of the clicked block by 1", "# remove:", "remove 2 pickaxes from the victim", "subtract 2.5 from {points.%player%}", "# remove all:", "remove every iron tool from the player", "remove all minecarts from {entitylist::*}", "# delete:", "delete the block below the player", "clear drops", "delete {variable}", "# reset:", "reset walk speed of player", "reset chunk at the targeted block"})
@Since(value="1.0 (set, add, remove, delete), 2.0 (remove all)")
public class EffChange
extends Effect {
    private static Patterns<Changer.ChangeMode> patterns = new Patterns(new Object[][]{{"(add|give) %objects% to %~objects%", Changer.ChangeMode.ADD}, {"increase %~objects% by %objects%", Changer.ChangeMode.ADD}, {"give %~objects% %objects%", Changer.ChangeMode.ADD}, {"set %~objects% to %objects%", Changer.ChangeMode.SET}, {"remove (all|every) %objects% from %~objects%", Changer.ChangeMode.REMOVE_ALL}, {"(remove|subtract) %objects% from %~objects%", Changer.ChangeMode.REMOVE}, {"reduce %~objects% by %objects%", Changer.ChangeMode.REMOVE}, {"(delete|clear) %~objects%", Changer.ChangeMode.DELETE}, {"reset %~objects%", Changer.ChangeMode.RESET}});
    private Expression<?> changed;
    private Expression<?> changer = null;
    private Changer.ChangeMode mode;
    private boolean single = true;

    static {
        Skript.registerEffect(EffChange.class, patterns.getPatterns());
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        String what;
        Object[] rs;
        this.mode = patterns.getInfo(matchedPattern);
        switch (this.mode) {
            case ADD: {
                if (matchedPattern == 0) {
                    this.changer = exprs[0];
                    this.changed = exprs[1];
                    break;
                }
                this.changer = exprs[1];
                this.changed = exprs[0];
                break;
            }
            case SET: {
                this.changer = exprs[1];
                this.changed = exprs[0];
                break;
            }
            case REMOVE_ALL: {
                this.changer = exprs[0];
                this.changed = exprs[1];
                break;
            }
            case REMOVE: {
                if (matchedPattern == 5) {
                    this.changer = exprs[0];
                    this.changed = exprs[1];
                    break;
                }
                this.changer = exprs[1];
                this.changed = exprs[0];
                break;
            }
            case DELETE: {
                this.changed = exprs[0];
                break;
            }
            case RESET: {
                this.changed = exprs[0];
            }
        }
        CountingLogHandler h = SkriptLogger.startLogHandler(new CountingLogHandler(Level.SEVERE));
        try {
            rs = this.changed.acceptChange(this.mode);
            ClassInfo<?> c = Classes.getSuperClassInfo(this.changed.getReturnType());
            what = c.getChanger() == null || !Arrays.equals(c.getChanger().acceptChange(this.mode), rs) ? this.changed.toString(null, false) : c.getName().withIndefiniteArticle();
        }
        finally {
            h.stop();
        }
        if (rs == null) {
            if (h.getCount() > 0) {
                return false;
            }
            switch (this.mode) {
                case SET: {
                    Skript.error(String.valueOf(what) + " can't be set to anything", ErrorQuality.SEMANTIC_ERROR);
                    break;
                }
                case DELETE: {
                    if (this.changed.acceptChange(Changer.ChangeMode.RESET) != null) {
                        Skript.error(String.valueOf(what) + " can't be deleted/cleared. It can however be reset which might result in the desired effect.", ErrorQuality.SEMANTIC_ERROR);
                        break;
                    }
                    Skript.error(String.valueOf(what) + " can't be deleted/cleared", ErrorQuality.SEMANTIC_ERROR);
                    break;
                }
                case REMOVE_ALL: {
                    if (this.changed.acceptChange(Changer.ChangeMode.REMOVE) != null) {
                        Skript.error(String.valueOf(what) + " can't have 'all of something' removed from it. Use 'remove' instead of 'remove all' to fix this.", ErrorQuality.SEMANTIC_ERROR);
                        break;
                    }
                }
                case ADD: 
                case REMOVE: {
                    Skript.error(String.valueOf(what) + " can't have anything " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " it", ErrorQuality.SEMANTIC_ERROR);
                    break;
                }
                case RESET: {
                    if (this.changed.acceptChange(Changer.ChangeMode.DELETE) != null) {
                        Skript.error(String.valueOf(what) + " can't be reset. It can however be deleted which might result in the desired effect.", ErrorQuality.SEMANTIC_ERROR);
                        break;
                    }
                    Skript.error(String.valueOf(what) + " can't be reset", ErrorQuality.SEMANTIC_ERROR);
                }
            }
            return false;
        }
        if (this.changer != null) {
            Expression<Object> v = null;
            Object x = null;
            ParseLogHandler log = SkriptLogger.startParseLogHandler();
            try {
                Object r;
                Object[] objectArray = rs;
                int n = rs.length;
                int n2 = 0;
                while (n2 < n) {
                    r = objectArray[n2];
                    log.clear();
                    if (((Class)(((Class)r).isArray() ? ((Class)r).getComponentType() : r)).isAssignableFrom(this.changer.getReturnType())) {
                        v = this.changer.getConvertedExpression(Object.class);
                        x = r;
                        break;
                    }
                    ++n2;
                }
                if (v == null) {
                    objectArray = rs;
                    n = rs.length;
                    n2 = 0;
                    while (n2 < n) {
                        r = objectArray[n2];
                        log.clear();
                        v = this.changer.getConvertedExpression(((Class)r).isArray() ? ((Class)r).getComponentType() : r);
                        if (v != null) {
                            x = r;
                            break;
                        }
                        ++n2;
                    }
                }
                if (v == null) {
                    if (log.hasError()) {
                        log.printError();
                        return false;
                    }
                    log.clear();
                    log.printLog();
                    r = new Class[rs.length];
                    int i = 0;
                    while (i < rs.length) {
                        r[i] = ((Class)rs[i]).isArray() ? ((Class)rs[i]).getComponentType() : rs[i];
                        ++i;
                    }
                    if (rs.length == 1 && rs[0] == Object.class) {
                        Skript.error("Can't understand this expression: " + this.changer, ErrorQuality.NOT_AN_EXPRESSION);
                    } else if (this.mode == Changer.ChangeMode.SET) {
                        Skript.error(String.valueOf(what) + " can't be set to " + this.changer + " because the latter is " + SkriptParser.notOfType(r), ErrorQuality.SEMANTIC_ERROR);
                    } else {
                        Skript.error(this.changer + " can't be " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " " + what + " because the former is " + SkriptParser.notOfType(r), ErrorQuality.SEMANTIC_ERROR);
                    }
                    return false;
                }
                log.printLog();
            }
            finally {
                log.stop();
            }
            if (((Class)x).isArray()) {
                this.single = false;
                x = ((Class)x).getComponentType();
            }
            this.changer = v;
            if (!this.changer.isSingle() && this.single) {
                if (this.mode == Changer.ChangeMode.SET) {
                    Skript.error(this.changed + " can only be set to one " + Classes.getSuperClassInfo(x).getName() + ", not more", ErrorQuality.SEMANTIC_ERROR);
                } else {
                    Skript.error("only one " + Classes.getSuperClassInfo(x).getName() + " can be " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " " + this.changed + ", not more", ErrorQuality.SEMANTIC_ERROR);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        ?[] delta;
        ?[] objArray = this.changer == null ? null : (delta = this.single ? (?[])this.changer.getSingle(e) : this.changer.getArray(e));
        if (delta == null && this.changer != null) {
            return;
        }
        this.changed.change(e, delta, this.mode);
    }

    @Override
    public String toString(Event e, boolean debug) {
        switch (this.mode) {
            case ADD: {
                return "add " + this.changer.toString(e, debug) + " to " + this.changed.toString(e, debug);
            }
            case SET: {
                return "set " + this.changed.toString(e, debug) + " to " + this.changer.toString(e, debug);
            }
            case REMOVE: {
                return "remove " + this.changer.toString(e, debug) + " from " + this.changed.toString(e, debug);
            }
            case REMOVE_ALL: {
                return "remove all " + this.changer.toString(e, debug) + " from " + this.changed.toString(e, debug);
            }
            case DELETE: {
                return "delete/clear " + this.changed.toString(e, debug);
            }
            case RESET: {
                return "reset " + this.changed.toString(e, debug);
            }
        }
        assert (false);
        return "";
    }
}

