/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Broadcast")
@Description(value={"Broadcasts a message to the server."})
@Examples(value={"broadcast \"Welcome %player% to the server!\"", "broadcast \"Woah! It's a message!\""})
@Since(value="1.0")
public class EffBroadcast
extends Effect {
    private Expression<String> messages;
    private Expression<World> worlds;

    static {
        Skript.registerEffect(EffBroadcast.class, "broadcast %strings% [(to|in) %-worlds%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.messages = vars[0];
        this.worlds = vars[1];
        return true;
    }

    @Override
    public void execute(Event e) {
        String[] stringArray = this.messages.getArray(e);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            Player[] playerArray;
            String m = stringArray[n2];
            if (this.worlds == null) {
                playerArray = Bukkit.getOnlinePlayers();
                n4 = playerArray.length;
                n3 = 0;
                while (n3 < n4) {
                    Player p = playerArray[n3];
                    p.sendMessage(m);
                    ++n3;
                }
                Bukkit.getConsoleSender().sendMessage(m);
            } else {
                playerArray = this.worlds.getArray(e);
                n4 = playerArray.length;
                n3 = 0;
                while (n3 < n4) {
                    Player w = playerArray[n3];
                    for (Player p : w.getPlayers()) {
                        p.sendMessage(m);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "broadcast " + this.messages.toString(e, debug) + (this.worlds == null ? "" : " to " + this.worlds.toString(e, debug));
    }
}

