/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.ConfigReader;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.InvalidNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.config.VoidNode;
import ch.njol.skript.config.validate.EntryValidator;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Checker;
import ch.njol.util.iterator.CheckedIterator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class SectionNode
extends Node
implements Iterable<Node> {
    private final ArrayList<Node> nodes = new ArrayList();
    private transient Map<String, Node> nodeMap = null;

    public SectionNode(String key, SectionNode parent, ConfigReader r) {
        super(key, parent, r);
    }

    SectionNode(Config c) {
        super(c);
    }

    public SectionNode(String key, SectionNode parent, String orig, int lineNum) {
        super(key, parent, orig, lineNum);
    }

    public int size() {
        return this.nodes.size();
    }

    public void add(Node n) {
        this.modified();
        this.nodes.add(n);
        this.nodeMap.put(n.key.toLowerCase(Locale.ENGLISH), n);
    }

    public void remove(Node n) {
        this.modified();
        this.nodes.remove(n);
        this.nodeMap.remove(n.key.toLowerCase(Locale.ENGLISH));
    }

    public void remove(String key) {
        this.modified();
        this.nodes.remove(this.nodeMap.remove(key.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Iterator<Node> iterator() {
        return new CheckedIterator<Node>(this.nodes.iterator(), (Checker)new Checker<Node>(){

            @Override
            public boolean check(Node n) {
                return !n.isVoid();
            }
        }){

            @Override
            public boolean hasNext() {
                boolean hasNext = super.hasNext();
                if (!hasNext) {
                    SkriptLogger.setNode(SectionNode.this);
                }
                return hasNext;
            }

            @Override
            public Node next() {
                Node n = (Node)super.next();
                SkriptLogger.setNode(n);
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Node get(String key) {
        if (this.nodeMap == null) {
            this.nodeMap = new HashMap<String, Node>();
            for (Node node : this.nodes) {
                if (node.isVoid()) continue;
                this.nodeMap.put(node.key.toLowerCase(Locale.ENGLISH), node);
            }
        }
        return this.nodeMap.get(key.toLowerCase(Locale.ENGLISH));
    }

    public String get(String name, String def) {
        Node n = this.get(name);
        if (n == null || !(n instanceof EntryNode)) {
            return def;
        }
        return ((EntryNode)n).getValue();
    }

    public void set(String key, String value) {
        Node n = this.get(key);
        if (n instanceof EntryNode) {
            ((EntryNode)n).setValue(value);
        } else if (n == null) {
            this.add(new EntryNode(key, value, this));
        }
    }

    public boolean isEmpty() {
        for (Node node : this.nodes) {
            if (node.isVoid()) continue;
            return false;
        }
        return true;
    }

    static final SectionNode load(Config c, ConfigReader r) throws IOException {
        return new SectionNode(c).load_i(r);
    }

    static final SectionNode load(String name, SectionNode parent, ConfigReader r) throws IOException {
        ++parent.config.level;
        SectionNode node = new SectionNode(name, parent, r).load_i(r);
        SkriptLogger.setNode(parent);
        --parent.config.level;
        return node;
    }

    private static final String readableWhitespace(String s) {
        if (s.matches(" +")) {
            return String.valueOf(s.length()) + " space" + (s.length() == 1 ? "" : "s");
        }
        if (s.matches("\t+")) {
            return String.valueOf(s.length()) + " tab" + (s.length() == 1 ? "" : "s");
        }
        return "'" + s.replace("\t", "->").replace(' ', '_').replaceAll("\\s", "?") + "' [-> = tab, _ = space, ? = other whitespace]";
    }

    private final SectionNode load_i(ConfigReader r) throws IOException {
        while (r.readLine() != null) {
            String s;
            SkriptLogger.setNode(this);
            String line = r.getLine().replaceFirst("(?<!#)#(?!#).*$", "").replace("##", "#");
            if (this.config.getIndentation() == null && !line.matches("\\s*") && !line.matches("\\S.*")) {
                s = line.replaceFirst("\\S.*$", "");
                if (s.matches(" +") || s.matches("\t+")) {
                    this.config.setIndentation(s);
                } else {
                    this.nodes.add(new InvalidNode(this, r));
                    Skript.error("indentation error: indent must only consist of either spaces or tabs, but not mixed (found " + SectionNode.readableWhitespace(s) + ")");
                    continue;
                }
            }
            if (!line.matches("\\s*") && !line.matches("^(" + this.config.getIndentation() + "){" + this.config.level + "}\\S.*")) {
                if (line.matches("^(" + this.config.getIndentation() + "){" + this.config.level + "}\\s.*") || !line.matches("^(" + this.config.getIndentation() + ")*\\S.*")) {
                    s = line.replaceFirst("\\S.*$", "");
                    this.nodes.add(new InvalidNode(this, r));
                    Skript.error("indentation error: expected " + this.config.level * this.config.getIndentation().length() + " " + this.config.getIndentationName() + (this.config.level * this.config.getIndentation().length() == 1 ? "" : "s") + ", but found " + SectionNode.readableWhitespace(s));
                    continue;
                }
                if (this.parent != null && !this.config.allowEmptySections && this.isEmpty()) {
                    Skript.warning("Empty configuration section! You might want to indent one or more of the subsequent lines to make them belong to this section or remove the colon at the end of the line if you don't want this line to start a section.");
                }
                r.reset();
                return this;
            }
            if ((line = line.trim()).isEmpty()) {
                this.nodes.add(new VoidNode(this, r));
                continue;
            }
            if (line.endsWith(":") && (this.config.simple || line.indexOf(this.config.separator) == -1 || this.config.separator.endsWith(":") && line.indexOf(this.config.separator) == line.length() - this.config.separator.length()) && !r.getLine().matches("([^#]|##)*#-#(\\s.*)?")) {
                this.nodes.add(SectionNode.load(line.substring(0, line.length() - 1), this, r));
                continue;
            }
            if (this.config.simple) {
                this.nodes.add(new SimpleNode(line, this, r));
                continue;
            }
            this.nodes.add(this.getEntry(line, r.getLine(), r.getLineNum(), this.config.separator));
        }
        SkriptLogger.setNode(this.parent);
        return this;
    }

    private final Node getEntry(String line, String orig, int lineNum, String separator) {
        int x = line.indexOf(separator);
        if (x == -1) {
            InvalidNode n = new InvalidNode(this, line, lineNum);
            EntryValidator.notAnEntryError(n);
            SkriptLogger.setNode(this);
            return n;
        }
        String key = line.substring(0, x).trim();
        String value = line.substring(x + separator.length()).trim();
        return new EntryNode(key, value, orig, this, lineNum);
    }

    public void convertToEntries(int levels) {
        this.convertToEntries(levels, this.config.separator);
    }

    public void convertToEntries(int levels, String separator) {
        if (levels < -1) {
            throw new IllegalArgumentException("levels must be >= -1");
        }
        if (!this.config.simple) {
            throw new SkriptAPIException("config is not simple");
        }
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = this.nodes.get(i);
            if (levels != 0 && n instanceof SectionNode) {
                ((SectionNode)n).convertToEntries(levels == -1 ? -1 : levels - 1, separator);
            }
            if (n instanceof SimpleNode) {
                this.nodes.set(i, this.getEntry(n.getKey(), n.getOrig(), n.lineNum, separator));
            }
            ++i;
        }
    }

    @Override
    void save(PrintWriter w) {
        if (this.parent != null) {
            if (!this.modified) {
                w.println(String.valueOf(this.getIndentation()) + this.orig.trim());
            } else {
                w.println(String.valueOf(this.getIndentation()) + this.key + ":" + this.getComment());
            }
        }
        for (Node node : this.nodes) {
            node.save(w);
        }
    }

    @Override
    String save() {
        assert (false);
        return String.valueOf(this.key) + ":" + this.getComment();
    }

    public boolean validate(SectionValidator validator) {
        return validator.validate(this);
    }

    HashMap<String, String> toMap(String prefix, String separator) {
        HashMap<String, String> r = new HashMap<String, String>();
        for (Node n : this) {
            if (n instanceof EntryNode) {
                r.put(String.valueOf(prefix) + n.getKey(), ((EntryNode)n).getValue());
                continue;
            }
            r.putAll(((SectionNode)n).toMap(String.valueOf(prefix) + n.getKey() + separator, separator));
        }
        return r;
    }

    boolean setValues(SectionNode other) {
        boolean r = false;
        for (Node n : this) {
            Node o = other.get(n.key);
            if (o == null) {
                r = true;
                continue;
            }
            if (n instanceof SectionNode) {
                if (o instanceof SectionNode) {
                    r |= ((SectionNode)n).setValues((SectionNode)o);
                    continue;
                }
                r = true;
                continue;
            }
            if (!(n instanceof EntryNode)) continue;
            if (o instanceof EntryNode) {
                ((EntryNode)n).setValue(((EntryNode)o).getValue());
                continue;
            }
            r = true;
        }
        if (!r) {
            for (Node o : other) {
                if (this.get(o.key) != null) continue;
                r = true;
                break;
            }
        }
        return r;
    }
}

