/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.ConfigReader;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.VoidNode;
import ch.njol.skript.log.SkriptLogger;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Node {
    protected String key;
    protected final int lineNum;
    protected String orig;
    protected boolean modified = false;
    private final boolean debug;
    protected final SectionNode parent;
    protected final Config config;
    private static final Pattern commentPattern = Pattern.compile("\\s*(?<!#)#(?!#).*$");

    protected Node(String key, SectionNode parent, String orig, int lineNum) {
        this.key = key;
        this.config = parent.getConfig();
        this.parent = parent;
        this.orig = orig;
        this.debug = orig.endsWith("#DEBUG#");
        this.lineNum = lineNum;
        SkriptLogger.setNode(this);
    }

    protected Node(String key, SectionNode parent, ConfigReader r) {
        this.key = key;
        this.config = parent.getConfig();
        this.parent = parent;
        this.orig = r.getLine();
        this.debug = this.orig.endsWith("#DEBUG#");
        this.lineNum = r.getLineNum();
        SkriptLogger.setNode(this);
    }

    protected Node(Config c) {
        this.key = null;
        this.orig = null;
        this.debug = false;
        this.lineNum = -1;
        this.config = c;
        this.parent = null;
        SkriptLogger.setNode(this);
    }

    protected Node(String key, SectionNode parent) {
        this.key = key;
        this.config = parent.getConfig();
        this.parent = parent;
        this.orig = null;
        this.debug = false;
        this.lineNum = -1;
        SkriptLogger.setNode(this);
    }

    public final String getKey() {
        return this.key;
    }

    public final Config getConfig() {
        return this.config;
    }

    public void rename(String newname) {
        if (this.key == null) {
            Skript.error("can't rename an anonymous node!");
            return;
        }
        this.key = newname;
        this.modified();
    }

    protected void modified() {
        this.modified = true;
        this.config.modified = true;
    }

    protected String getComment() {
        Matcher m = commentPattern.matcher(this.orig);
        if (!m.find()) {
            return "";
        }
        return m.group();
    }

    protected String getIndentation() {
        String s = "";
        Node n = this;
        while ((n = n.parent) != this.config.getMainNode()) {
            s = String.valueOf(s) + this.config.getIndentation();
        }
        return s;
    }

    void save(PrintWriter w) {
        if (!this.modified) {
            w.println(String.valueOf(this.getIndentation()) + this.orig.trim());
        } else {
            w.println(String.valueOf(this.getIndentation()) + this.save() + this.getComment());
        }
    }

    abstract String save();

    public SectionNode getParent() {
        return this.parent;
    }

    public void delete() {
        this.parent.remove(this);
    }

    public String getOrig() {
        return this.orig;
    }

    public int getLine() {
        return this.lineNum;
    }

    public boolean isVoid() {
        return this instanceof VoidNode;
    }

    public String toString() {
        if (this.parent == null) {
            return this.config.getFileName();
        }
        return String.valueOf(this.getOrig().trim()) + " (" + this.getConfig().getFileName() + ", line " + this.getLine() + ")";
    }

    public boolean debug() {
        return this.debug;
    }
}

