/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Is Holding")
@Description(value={"Checks whether a player is holdign a specific item. Cannot be used with endermen, use 'entity is [not] an enderman holding &lt;item type&gt;' instead."})
@Examples(value={"player is holding a stick", "victim isn't holding a sword of sharpness"})
@Since(value="1.0")
public class CondItemInHand
extends Condition {
    private Expression<Player> players;
    private Expression<ItemType> types;

    static {
        Skript.registerCondition(CondItemInHand.class, "[%players%] ha(s|ve) %itemtypes% in hand", "[%players%] (is|are) holding %itemtypes%", "[%players%] (ha(s|ve) not|do[es]n't have) %itemtypes% in hand", "[%players%] (is not|isn't) holding %itemtypes%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.players = vars[0];
        this.types = vars[1];
        this.setNegated(matchedPattern >= 2);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.players.check(e, new Checker<Player>(){

            @Override
            public boolean check(final Player p) {
                return CondItemInHand.this.types.check(e, new Checker<ItemType>(){

                    @Override
                    public boolean check(ItemType type) {
                        return type.isOfType(p.getItemInHand());
                    }
                }, CondItemInHand.this.isNegated());
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.players.toString(e, debug)) + " is holding " + this.types.toString(e, debug);
    }
}

