/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.util.Slot;
import org.bukkit.inventory.Inventory;

@Name(value="Is Empty")
@Description(value={"Checks whether an inventory, an inventory slot, or a text is empty."})
@Examples(value={"player's inventory is empty"})
@Since(value="")
public class CondIsEmpty
extends PropertyCondition<Object> {
    static {
        CondIsEmpty.register(CondIsEmpty.class, "empty", "inventories/slots/strings");
    }

    @Override
    public boolean check(Object o) {
        if (o instanceof String) {
            return ((String)o).isEmpty();
        }
        if (o instanceof Inventory) {
            return !((Inventory)o).iterator().hasNext();
        }
        if (o instanceof Slot) {
            Slot s = (Slot)o;
            return s.getItem() == null || s.getItem().getTypeId() == 0;
        }
        return false;
    }

    @Override
    protected String getPropertyName() {
        return "empty";
    }
}

