/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;

@Name(value="Time")
@Description(value={"Tests whether a given <a href='../classes/#date'>real time</a> was more or less than some <a href='../classes/#timespan'>time span</a> ago."})
@Examples(value={"command /command_with_cooldown:", "\ttrigger:", "\t\t{command.%player%.lastused} was less than a minute ago:", "\t\t\tmessage \"Please wait a minute between uses of this command.\"", "\t\t\tstop", "\t\tset {command.%player%.lastused} to now", "\t\t# ... actual command trigger here ..."})
@Since(value="2.0")
public class CondDate
extends Condition {
    private Expression<Date> date;
    private Expression<Timespan> delta;

    static {
        Skript.registerCondition(CondDate.class, "%date% (was|were)( more|(n't| not) less) than %timespan% [ago]", "%date% (was|were)((n't| not) more| less) than %timespan% [ago]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.date = exprs[0];
        this.delta = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        final long now = System.currentTimeMillis();
        return this.date.check(e, new Checker<Date>(){

            @Override
            public boolean check(final Date d) {
                return CondDate.this.delta.check(e, new Checker<Timespan>(){

                    @Override
                    public boolean check(Timespan t) {
                        return now - d.getTimestamp() >= t.getMilliSeconds();
                    }
                }, CondDate.this.isNegated());
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.date.toString(e, debug)) + " was " + (this.isNegated() ? "less" : "more") + " than " + this.delta.toString(e, debug) + " ago";
    }
}

