/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.util.Patterns;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;

@Name(value="Comparison")
@Description(value={"A very general condition, it simply compares two values. Usually you can only compare for equality (e.g. block is/isn't of &lt;type&gt;), but some values can also be compared using greater than/less than. In that case you can also test for whether an object is between two others.", "Note: This is the only element where not all patterns are shown. It has actually another two sets of similar patters, but with <code>(was|were)</code> or <code>will be</code> instead of <code>(is|are)</code> respectively, which check different <a href='../expressions/#ExprTimeState'>time states</a> of the first expression."})
@Examples(value={"the clicked block is a stone slab or a double stone slab", "time in the player's world is greater than 8:00", "the creature is not an enderman or an ender dragon"})
@Since(value="1.0")
public class CondCompare
extends Condition {
    private static final Patterns<Comparator.Relation> patterns = new Patterns(new Object[][]{{"%objects% ((is|are) ((greater|more|higher|bigger|larger) than|above)|\\>) %objects%", Comparator.Relation.GREATER}, {"%objects% ((is|are) (greater|more|higher|bigger|larger|above) [than] or (equal to|the same as)|(is not|are not|isn't|aren't) ((less|smaller) than|below)|\\>=) %objects%", Comparator.Relation.GREATER_OR_EQUAL}, {"%objects% ((is|are) ((less|smaller) than|below)|\\<) %objects%", Comparator.Relation.SMALLER}, {"%objects% ((is|are) (less|smaller|below) [than] or (equal to|the same as)|(is not|are not|isn't|aren't) ((greater|more|higher|bigger|larger) than|above)|\\<=) %objects%", Comparator.Relation.SMALLER_OR_EQUAL}, {"%objects% ((is|are) (not|neither)|isn't|aren't|!=) [equal to] %objects%", Comparator.Relation.NOT_EQUAL}, {"%objects% (is|are|=) [(equal to|the same as)] %objects%", Comparator.Relation.EQUAL}, {"%objects% (is|are) between %objects% and %objects%", Comparator.Relation.EQUAL}, {"%objects% (is not|are not|isn't|aren't) between %objects% and %objects%", Comparator.Relation.NOT_EQUAL}, {"%objects@-1% (was|were) ((greater|more|higher|bigger|larger) than|above) %objects%", Comparator.Relation.GREATER}, {"%objects@-1% ((was|were) (greater|more|higher|bigger|larger|above) [than] or (equal to|the same as)|(was not|were not|wasn't|weren't) ((less|smaller) than|below)) %objects%", Comparator.Relation.GREATER_OR_EQUAL}, {"%objects@-1% (was|were) ((less|smaller) than|below) %objects%", Comparator.Relation.SMALLER}, {"%objects@-1% ((was|were) (less|smaller|below) [than] or (equal to|the same as)|(was not|were not|wasn't|weren't) ((greater|more|higher|bigger|larger) than|above)) %objects%", Comparator.Relation.SMALLER_OR_EQUAL}, {"%objects@-1% ((was|were) (not|neither)|wasn't|weren't) [equal to] %objects%", Comparator.Relation.NOT_EQUAL}, {"%objects@-1% (was|were) [(equal to|the same as)] %objects%", Comparator.Relation.EQUAL}, {"%objects@-1% (was|were) between %objects% and %objects%", Comparator.Relation.EQUAL}, {"%objects@-1% (was not|were not|wasn't|weren't) between %objects% and %objects%", Comparator.Relation.NOT_EQUAL}, {"%objects@1% will be ((greater|more|higher|bigger|larger) than|above) %objects%", Comparator.Relation.GREATER}, {"%objects@1% (will be (greater|more|higher|bigger|larger|above) [than] or (equal to|the same as)|(will not|won't) be ((less|smaller) than|below)) %objects%", Comparator.Relation.GREATER_OR_EQUAL}, {"%objects@1% will be ((less|smaller) than|below) %objects%", Comparator.Relation.SMALLER}, {"%objects@1% (will be (less|smaller|below) [than] or (equal to|the same as)|(will not|won't) be ((greater|more|higher|bigger|larger) than|above)) %objects%", Comparator.Relation.SMALLER_OR_EQUAL}, {"%objects@1% ((will (not|neither) be|won't be)|(isn't|aren't|is not|are not) (turning|changing) [in]to) [equal to] %objects%", Comparator.Relation.NOT_EQUAL}, {"%objects@1% (will be [(equal to|the same as)]|(is|are) (turning|changing) [in]to) %objects%", Comparator.Relation.EQUAL}, {"%objects@1% will be between %objects% and %objects%", Comparator.Relation.EQUAL}, {"%objects@1% (will not be|won't be) between %objects% and %objects%", Comparator.Relation.NOT_EQUAL}});
    private Expression<?> first;
    private Expression<?> second;
    private Expression<?> third;
    private Comparator.Relation relation;
    private Comparator comp;

    static {
        Skript.registerCondition(CondCompare.class, patterns.getPatterns());
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.first = vars[0];
        this.second = vars[1];
        if (vars.length == 3) {
            this.third = vars[2];
        }
        this.relation = patterns.getInfo(matchedPattern);
        boolean b = this.init();
        if (!b) {
            if (this.third == null && this.first.getReturnType() == Object.class && this.second.getReturnType() == Object.class) {
                return false;
            }
            Skript.error("Can't compare " + CondCompare.f(this.first) + " with " + CondCompare.f(this.second) + (this.third == null ? "" : " and " + CondCompare.f(this.third)), ErrorQuality.NOT_AN_EXPRESSION);
            return false;
        }
        if (this.comp != null) {
            if (this.third == null) {
                if (!this.relation.isEqualOrInverse() && !this.comp.supportsOrdering()) {
                    Skript.error("Can't test " + CondCompare.f(this.first) + " for being '" + (Object)((Object)this.relation) + "' " + CondCompare.f(this.second), ErrorQuality.NOT_AN_EXPRESSION);
                    return false;
                }
            } else if (!this.comp.supportsOrdering()) {
                Skript.error("Can't test " + CondCompare.f(this.first) + " for being 'between' " + CondCompare.f(this.second) + " and " + CondCompare.f(this.third), ErrorQuality.NOT_AN_EXPRESSION);
                return false;
            }
        }
        return true;
    }

    public static final String f(Expression<?> e) {
        if (e.getReturnType() == Object.class) {
            return e.toString(null, false);
        }
        return Classes.getSuperClassInfo(e.getReturnType()).getName().withIndefiniteArticle();
    }

    private boolean init() {
        Class<?> s;
        RetainingLogHandler log = SkriptLogger.startRetainingLog();
        try {
            Expression<Object> e;
            if (this.first.getReturnType() == Object.class) {
                e = this.first.getConvertedExpression(Object.class);
                if (e == null) {
                    log.printErrors();
                    return false;
                }
                this.first = e;
            }
            if (this.second.getReturnType() == Object.class) {
                e = this.second.getConvertedExpression(Object.class);
                if (e == null) {
                    log.printErrors();
                    return false;
                }
                this.second = e;
            }
            if (this.third != null && this.third.getReturnType() == Object.class) {
                e = this.third.getConvertedExpression(Object.class);
                if (e == null) {
                    log.printErrors();
                    return false;
                }
                this.third = e;
            }
            log.printLog();
        }
        finally {
            log.stop();
        }
        Class<?> f = this.first.getReturnType();
        Class<?> clazz = s = this.third == null ? this.second.getReturnType() : Utils.getSuperType(this.second.getReturnType(), this.third.getReturnType());
        if (f == Object.class || s == Object.class) {
            return true;
        }
        this.comp = Comparators.getComparator(f, s);
        return this.comp != null;
    }

    @Override
    public boolean check(final Event e) {
        return this.first.check(e, new Checker<Object>(){

            @Override
            public boolean check(final Object o1) {
                return (CondCompare.this.relation == Comparator.Relation.NOT_EQUAL && CondCompare.this.third == null) ^ CondCompare.this.second.check(e, new Checker<Object>(){

                    @Override
                    public boolean check(final Object o2) {
                        if (CondCompare.this.third == null) {
                            return CondCompare.this.relation == Comparator.Relation.NOT_EQUAL ^ CondCompare.this.relation.is(CondCompare.this.comp != null ? CondCompare.this.comp.compare(o1, o2) : Comparators.compare(o1, o2));
                        }
                        return CondCompare.this.third.check(e, new Checker<Object>(){

                            @Override
                            public boolean check(Object o3) {
                                return CondCompare.this.relation == Comparator.Relation.NOT_EQUAL ^ (Comparator.Relation.GREATER_OR_EQUAL.is(CondCompare.this.comp != null ? CondCompare.this.comp.compare(o1, o2) : Comparators.compare(o1, o2)) && Comparator.Relation.SMALLER_OR_EQUAL.is(CondCompare.this.comp != null ? CondCompare.this.comp.compare(o1, o3) : Comparators.compare(o1, o3)));
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        String s = this.third == null ? String.valueOf(this.first.toString(e, debug)) + " is " + (Object)((Object)this.relation) + " " + this.second.toString(e, debug) : String.valueOf(this.first.toString(e, debug)) + " is" + (this.relation == Comparator.Relation.EQUAL ? "" : " not") + " between " + this.second.toString(e, debug) + " and " + this.third.toString(e, debug);
        if (debug) {
            s = String.valueOf(s) + " (comparator: " + this.comp + ")";
        }
        return s;
    }
}

