/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.SerializableConverter;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.entity.XpOrbData;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.BlockUtils;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.Experience;
import ch.njol.skript.util.Slot;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class DefaultConverters {
    static {
        Converters.registerConverter(OfflinePlayer.class, PlayerInventory.class, new SerializableConverter<OfflinePlayer, PlayerInventory>(){

            @Override
            public PlayerInventory convert(OfflinePlayer p) {
                if (!p.isOnline()) {
                    return null;
                }
                return p.getPlayer().getInventory();
            }
        });
        Converters.registerConverter(OfflinePlayer.class, Player.class, new SerializableConverter<OfflinePlayer, Player>(){

            @Override
            public Player convert(OfflinePlayer p) {
                return p.getPlayer();
            }
        });
        Converters.registerConverter(CommandSender.class, Player.class, new SerializableConverter<CommandSender, Player>(){

            @Override
            public Player convert(CommandSender s) {
                if (s instanceof Player) {
                    return (Player)s;
                }
                return null;
            }
        });
        Converters.registerConverter(Entity.class, Player.class, new SerializableConverter<Entity, Player>(){

            @Override
            public Player convert(Entity e) {
                if (e instanceof Player) {
                    return (Player)e;
                }
                return null;
            }
        });
        Converters.registerConverter(Entity.class, LivingEntity.class, new SerializableConverter<Entity, LivingEntity>(){

            @Override
            public LivingEntity convert(Entity e) {
                if (e instanceof LivingEntity) {
                    return (LivingEntity)e;
                }
                return null;
            }
        });
        Converters.registerConverter(Block.class, Inventory.class, new SerializableConverter<Block, Inventory>(){

            @Override
            public Inventory convert(Block b) {
                if (b.getState() instanceof InventoryHolder) {
                    return ((InventoryHolder)b.getState()).getInventory();
                }
                return null;
            }
        });
        Converters.registerConverter(Block.class, ItemStack.class, new SerializableConverter<Block, ItemStack>(){

            @Override
            public ItemStack convert(Block b) {
                return new ItemStack(b.getTypeId(), 1, (short)b.getData());
            }
        }, 1);
        Converters.registerConverter(Block.class, Location.class, new SerializableConverter<Block, Location>(){

            @Override
            public Location convert(Block b) {
                return BlockUtils.getLocation(b);
            }
        });
        Converters.registerConverter(Entity.class, Location.class, new SerializableConverter<Entity, Location>(){

            @Override
            public Location convert(Entity e) {
                return e.getLocation();
            }
        });
        Converters.registerConverter(Entity.class, EntityData.class, new SerializableConverter<Entity, EntityData>(){

            @Override
            public EntityData convert(Entity e) {
                return EntityData.fromEntity(e);
            }
        });
        Converters.registerConverter(EntityData.class, EntityType.class, new SerializableConverter<EntityData, EntityType>(){

            @Override
            public EntityType convert(EntityData data) {
                return new EntityType(data, -1);
            }
        });
        Converters.registerConverter(ItemType.class, ItemStack.class, new SerializableConverter<ItemType, ItemStack>(){

            @Override
            public ItemStack convert(ItemType i) {
                return i.getRandom();
            }
        });
        Converters.registerConverter(ItemStack.class, ItemType.class, new SerializableConverter<ItemStack, ItemType>(){

            @Override
            public ItemType convert(ItemStack i) {
                return new ItemType(i);
            }
        });
        Converters.registerConverter(Experience.class, XpOrbData.class, new SerializableConverter<Experience, XpOrbData>(){

            @Override
            public XpOrbData convert(Experience e) {
                return new XpOrbData(e.getXP());
            }
        });
        Converters.registerConverter(XpOrbData.class, Experience.class, new SerializableConverter<XpOrbData, Experience>(){

            @Override
            public Experience convert(XpOrbData e) {
                return new Experience(e.getExperience());
            }
        });
        Converters.registerConverter(Slot.class, ItemStack.class, new SerializableConverter<Slot, ItemStack>(){

            @Override
            public ItemStack convert(Slot s) {
                ItemStack i = s.getItem();
                if (i == null) {
                    return new ItemStack(0, 1);
                }
                return i;
            }
        });
        Converters.registerConverter(Block.class, InventoryHolder.class, new SerializableConverter<Block, InventoryHolder>(){

            @Override
            public InventoryHolder convert(Block b) {
                if (b.getState() == null) {
                    return null;
                }
                BlockState s = b.getState();
                if (s instanceof InventoryHolder) {
                    return (InventoryHolder)s;
                }
                return null;
            }
        });
        Converters.registerConverter(Enchantment.class, EnchantmentType.class, new SerializableConverter<Enchantment, EnchantmentType>(){

            @Override
            public EnchantmentType convert(Enchantment e) {
                return new EnchantmentType(e, -1);
            }
        });
    }
}

