/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.SerializableChanger;
import ch.njol.skript.util.Experience;
import ch.njol.util.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffectType;

public class DefaultChangers {
    public static final SerializableChanger<Entity, Object> entityChanger = new SerializableChanger<Entity, Object>(){

        @Override
        public Class<? extends Object>[] acceptChange(Changer.ChangeMode mode) {
            switch (mode) {
                case ADD: {
                    return CollectionUtils.array(ItemType[].class, Inventory.class, Experience[].class);
                }
                case DELETE: {
                    return CollectionUtils.array(new Class[0]);
                }
                case REMOVE: {
                    return CollectionUtils.array(PotionEffectType[].class, ItemType[].class, Inventory.class);
                }
                case REMOVE_ALL: {
                    return CollectionUtils.array(PotionEffectType[].class, ItemType[].class);
                }
                case SET: 
                case RESET: {
                    return null;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        public void change(Entity[] entities, Object delta, Changer.ChangeMode mode) {
            if (delta instanceof PotionEffectType[]) {
                if (!$assertionsDisabled && mode != Changer.ChangeMode.REMOVE && mode != Changer.ChangeMode.REMOVE_ALL) {
                    throw new AssertionError();
                }
                Entity[] entityArray = entities;
                int n = entities.length;
                int n2 = 0;
                while (n2 < n) {
                    Entity e = entityArray[n2];
                    if (e instanceof LivingEntity) {
                        PotionEffectType[] potionEffectTypeArray = (PotionEffectType[])delta;
                        int n3 = potionEffectTypeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            PotionEffectType t = potionEffectTypeArray[n4];
                            ((LivingEntity)e).removePotionEffect(t);
                            ++n4;
                        }
                    }
                    ++n2;
                }
            } else {
                Entity[] entityArray = entities;
                int n = entities.length;
                int n5 = 0;
                while (n5 < n) {
                    Entity e = entityArray[n5];
                    if (!(e instanceof Player)) {
                        if (mode == Changer.ChangeMode.DELETE) {
                            e.remove();
                        }
                    } else if (mode != Changer.ChangeMode.DELETE) {
                        int n6;
                        Object[] objectArray;
                        Player p = (Player)e;
                        if (delta instanceof Experience[]) {
                            int xp = 0;
                            objectArray = (Experience[])delta;
                            n6 = objectArray.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                Object x = objectArray[n7];
                                xp += ((Experience)x).getXP();
                                ++n7;
                            }
                            p.giveExp(xp);
                        } else if (delta instanceof Inventory) {
                            PlayerInventory invi = p.getInventory();
                            if (mode == Changer.ChangeMode.ADD) {
                                for (ItemStack i : (Inventory)delta) {
                                    if (i == null) continue;
                                    invi.addItem(new ItemStack[]{i});
                                }
                            } else {
                                invi.removeItem(((Inventory)delta).getContents());
                            }
                            p.updateInventory();
                        } else {
                            PlayerInventory invi = p.getInventory();
                            objectArray = (ItemType[])delta;
                            n6 = objectArray.length;
                            int n8 = 0;
                            while (n8 < n6) {
                                Object type = objectArray[n8];
                                if (mode == Changer.ChangeMode.ADD) {
                                    ((ItemType)type).addTo((Inventory)invi);
                                } else if (mode == Changer.ChangeMode.REMOVE) {
                                    ((ItemType)type).removeFrom((Inventory)invi);
                                } else {
                                    ((ItemType)type).removeAll((Inventory)invi);
                                }
                                ++n8;
                            }
                            p.updateInventory();
                        }
                    }
                    ++n5;
                }
            }
        }
    };
    public static final SerializableChanger<Player, Object> playerChanger = new SerializableChanger<Player, Object>(){

        @Override
        public Class<? extends Object>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.DELETE) {
                return null;
            }
            return entityChanger.acceptChange(mode);
        }

        public void change(Player[] players, Object delta, Changer.ChangeMode mode) {
            entityChanger.change((Entity[])players, delta, mode);
        }
    };
    public static final SerializableChanger<Entity, Object> nonLivingEntityChanger = new SerializableChanger<Entity, Object>(){

        @Override
        public Class<Object>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.DELETE) {
                return CollectionUtils.array(new Class[0]);
            }
            return null;
        }

        public void change(Entity[] entities, Object delta, Changer.ChangeMode mode) {
            if (!$assertionsDisabled && mode != Changer.ChangeMode.DELETE) {
                throw new AssertionError();
            }
            Entity[] entityArray = entities;
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                Entity e = entityArray[n2];
                if (!(e instanceof Player)) {
                    e.remove();
                }
                ++n2;
            }
        }
    };
    public static final SerializableChanger<Item, Object> itemChanger = new SerializableChanger<Item, Object>(){

        @Override
        public Class<?>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.SET) {
                return CollectionUtils.array(ItemStack.class);
            }
            return nonLivingEntityChanger.acceptChange(mode);
        }

        public void change(Item[] what, Object delta, Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.SET) {
                Item[] itemArray = what;
                int n = what.length;
                int n2 = 0;
                while (n2 < n) {
                    Item i = itemArray[n2];
                    i.setItemStack((ItemStack)delta);
                    ++n2;
                }
            } else {
                nonLivingEntityChanger.change((Entity[])what, delta, mode);
            }
        }
    };
    public static final SerializableChanger<Inventory, Object> inventoryChanger = new SerializableChanger<Inventory, Object>(){

        @Override
        public Class<? extends Object>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.RESET) {
                return null;
            }
            if (mode == Changer.ChangeMode.REMOVE_ALL) {
                return CollectionUtils.array(ItemType[].class);
            }
            return CollectionUtils.array(ItemType[].class, Inventory.class);
        }

        public void change(Inventory[] invis, Object delta, Changer.ChangeMode mode) {
            Inventory[] inventoryArray = invis;
            int n = invis.length;
            int n2 = 0;
            while (n2 < n) {
                Inventory invi = inventoryArray[n2];
                switch (mode) {
                    case DELETE: {
                        invi.clear();
                        if (!(invi instanceof PlayerInventory)) break;
                        ((PlayerInventory)invi).setArmorContents(new ItemStack[4]);
                        if (!(((PlayerInventory)invi).getHolder() instanceof Player)) break;
                        Player p = (Player)((PlayerInventory)invi).getHolder();
                        if (invi.equals(p.getOpenInventory().getBottomInventory())) {
                            p.getOpenInventory().setCursor(null);
                        }
                        if (!(p.getOpenInventory().getTopInventory() instanceof CraftingInventory)) break;
                        p.getOpenInventory().getTopInventory().clear();
                        break;
                    }
                    case SET: {
                        invi.clear();
                    }
                    case ADD: {
                        ItemType type;
                        int n3;
                        ItemType[] itemTypeArray;
                        if (delta instanceof Inventory) {
                            for (ItemStack i : (Inventory)delta) {
                                if (i == null) continue;
                                invi.addItem(new ItemStack[]{i});
                            }
                        } else {
                            itemTypeArray = (ItemType[])delta;
                            n3 = itemTypeArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                type = itemTypeArray[n4];
                                type.addTo(invi);
                                ++n4;
                            }
                        }
                        break;
                    }
                    case REMOVE: 
                    case REMOVE_ALL: {
                        ItemType type;
                        if (delta instanceof Inventory) {
                            if (!$assertionsDisabled && mode != Changer.ChangeMode.REMOVE) {
                                throw new AssertionError();
                            }
                            invi.removeItem(((Inventory)delta).getContents());
                            break;
                        }
                        ItemType[] itemTypeArray = (ItemType[])delta;
                        int n3 = itemTypeArray.length;
                        int n5 = 0;
                        while (n5 < n3) {
                            type = itemTypeArray[n5];
                            if (mode == Changer.ChangeMode.REMOVE) {
                                type.removeFrom(invi);
                            } else {
                                type.removeAll(invi);
                            }
                            ++n5;
                        }
                        break;
                    }
                    case RESET: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                if (invi.getHolder() instanceof Player) {
                    ((Player)invi.getHolder()).updateInventory();
                }
                ++n2;
            }
        }
    };
    public static final SerializableChanger<Block, Object> blockChanger = new SerializableChanger<Block, Object>(){

        @Override
        public Class<?>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.RESET) {
                return null;
            }
            if (mode == Changer.ChangeMode.SET) {
                return CollectionUtils.array(ItemType.class);
            }
            return CollectionUtils.array(ItemType[].class, Inventory.class);
        }

        public void change(Block[] blocks, Object delta, Changer.ChangeMode mode) {
            Block[] blockArray = blocks;
            int n = blocks.length;
            int n2 = 0;
            while (n2 < n) {
                Block block = blockArray[n2];
                switch (mode) {
                    case SET: {
                        ((ItemType)delta).getBlock().setBlock(block, true);
                        break;
                    }
                    case DELETE: {
                        block.setTypeId(0, true);
                        break;
                    }
                    case ADD: 
                    case REMOVE: 
                    case REMOVE_ALL: {
                        ItemType type;
                        int n3;
                        ItemType[] itemTypeArray;
                        BlockState state = block.getState();
                        if (!(state instanceof InventoryHolder)) break;
                        Inventory invi = ((InventoryHolder)state).getInventory();
                        if (mode == Changer.ChangeMode.ADD) {
                            if (delta instanceof Inventory) {
                                for (ItemStack i : (Inventory)delta) {
                                    if (i == null) continue;
                                    invi.addItem(new ItemStack[]{i});
                                }
                            } else {
                                itemTypeArray = (ItemType[])delta;
                                n3 = itemTypeArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    type = itemTypeArray[n4];
                                    type.addTo(invi);
                                    ++n4;
                                }
                            }
                        } else if (delta instanceof Inventory) {
                            invi.removeItem(((Inventory)delta).getContents());
                        } else {
                            itemTypeArray = (ItemType[])delta;
                            n3 = itemTypeArray.length;
                            int n5 = 0;
                            while (n5 < n3) {
                                type = itemTypeArray[n5];
                                if (mode == Changer.ChangeMode.REMOVE) {
                                    type.removeFrom(invi);
                                } else {
                                    type.removeAll(invi);
                                }
                                ++n5;
                            }
                        }
                        state.update();
                        break;
                    }
                    case RESET: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                ++n2;
            }
        }
    };
}

