/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.classes.Serializer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;

public class ConfigurationSerializer<T extends ConfigurationSerializable>
implements Serializer<T> {
    private final Class<T> c;

    public ConfigurationSerializer(Class<T> c) {
        this.c = c;
    }

    @Override
    public String serialize(T o) {
        return ConfigurationSerializer.serializeCS(o);
    }

    @Override
    public T deserialize(String s) {
        return (T)((ConfigurationSerializable)ConfigurationSerializer.deserializeCS(s, this.c));
    }

    public static final String serializeCS(ConfigurationSerializable o) {
        YamlConfiguration y = new YamlConfiguration();
        y.set("value", (Object)o);
        return y.saveToString().replace("\n", "\ufeff");
    }

    public static final <T> T deserializeCS(String s, Class<T> c) {
        YamlConfiguration y = new YamlConfiguration();
        try {
            y.loadFromString(s.replace("\ufeff", "\n"));
        }
        catch (InvalidConfigurationException e) {
            return null;
        }
        Object o = y.get("value");
        if (!c.isInstance(o)) {
            return null;
        }
        return (T)o;
    }

    @Override
    public boolean mustSyncDeserialization() {
        return false;
    }
}

