/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes;

import ch.njol.skript.classes.Arithmetic;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.SerializableChanger;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.Debuggable;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.localization.Noun;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.event.Event;

public class ClassInfo<T>
implements Debuggable {
    private final Class<T> c;
    private final String codeName;
    private final Noun name;
    private DefaultExpression<T> defaultExpression = null;
    private Parser<? extends T> parser = null;
    private Pattern[] userInputPatterns = null;
    private SerializableChanger<? super T, ?> changer = null;
    private Serializer<? super T> serializer = null;
    private Class<?> serializeAs = null;
    private Arithmetic<T, ?> math = null;
    private Class<?> mathRelativeType = null;
    private String docName = null;
    private String[] description = null;
    private String[] usage = null;
    private String[] examples = null;
    private String since = null;
    public static final String NO_DOC = new String();
    private final Set<String> before = new HashSet<String>();
    private Set<String> after;

    public ClassInfo(Class<T> c, String codeName) {
        this.c = c;
        if (!codeName.matches("[a-z0-9]+")) {
            throw new IllegalArgumentException("Code names for classes must be lowercase and only consist of latin letters and arabic numbers");
        }
        this.codeName = codeName;
        this.name = new Noun("types." + codeName);
    }

    public ClassInfo<T> parser(Parser<? extends T> parser) {
        assert (this.parser == null);
        this.parser = parser;
        return this;
    }

    public ClassInfo<T> user(String ... userInputPatterns) throws PatternSyntaxException {
        assert (this.userInputPatterns == null);
        this.userInputPatterns = new Pattern[userInputPatterns.length];
        int i = 0;
        while (i < userInputPatterns.length) {
            this.userInputPatterns[i] = Pattern.compile(userInputPatterns[i]);
            ++i;
        }
        return this;
    }

    public ClassInfo<T> defaultExpression(DefaultExpression<T> defaultExpression) {
        assert (this.defaultExpression == null);
        if (!defaultExpression.isDefault()) {
            throw new IllegalArgumentException("defaultExpression.isDefault() must return true for the default expression of a class");
        }
        this.defaultExpression = defaultExpression;
        return this;
    }

    public ClassInfo<T> serializer(Serializer<? super T> serializer) {
        assert (this.serializer == null);
        if (this.serializeAs != null) {
            throw new IllegalStateException("Can't set a serializer if this class is set to be serialized as another one");
        }
        this.serializer = serializer;
        return this;
    }

    public ClassInfo<T> serializeAs(Class<?> serializeAs) {
        assert (this.serializeAs == null);
        if (this.serializer != null) {
            throw new IllegalStateException("Can't set this class to be serialized as another one if a serializer is already set");
        }
        this.serializeAs = serializeAs;
        return this;
    }

    public ClassInfo<T> changer(SerializableChanger<? super T, ?> changer) {
        assert (this.changer == null);
        this.changer = changer;
        return this;
    }

    public <R> ClassInfo<T> math(Class<R> relativeType, Arithmetic<T, R> math) {
        assert (this.math == null);
        this.math = math;
        this.mathRelativeType = relativeType;
        return this;
    }

    public ClassInfo<T> name(String name) {
        assert (this.docName == null);
        this.docName = name;
        return this;
    }

    public ClassInfo<T> description(String ... description) {
        assert (this.description == null);
        this.description = description;
        return this;
    }

    public ClassInfo<T> usage(String ... usage) {
        assert (this.usage == null);
        this.usage = usage;
        return this;
    }

    public ClassInfo<T> examples(String ... examples) {
        assert (this.examples == null);
        this.examples = examples;
        return this;
    }

    public ClassInfo<T> since(String since) {
        assert (this.since == null);
        this.since = since;
        return this;
    }

    public Class<T> getC() {
        return this.c;
    }

    public Noun getName() {
        return this.name;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public DefaultExpression<T> getDefaultExpression() {
        return this.defaultExpression;
    }

    public Parser<? extends T> getParser() {
        return this.parser;
    }

    public Pattern[] getUserInputPatterns() {
        return this.userInputPatterns;
    }

    public SerializableChanger<? super T, ?> getChanger() {
        return this.changer;
    }

    public Serializer<? super T> getSerializer() {
        return this.serializer;
    }

    public Class<?> getSerializeAs() {
        return this.serializeAs;
    }

    public Arithmetic<T, ?> getMath() {
        return this.math;
    }

    public Class<?> getMathRelativeType() {
        return this.mathRelativeType;
    }

    public String[] getDescription() {
        return this.description;
    }

    public String[] getUsage() {
        return this.usage;
    }

    public String[] getExamples() {
        return this.examples;
    }

    public String getSince() {
        return this.since;
    }

    public String getDocName() {
        return this.docName;
    }

    public ClassInfo<T> before(String ... before) {
        this.before.addAll(Arrays.asList(before));
        return this;
    }

    public ClassInfo<T> after(String ... after) {
        assert (this.after == null);
        this.after = new HashSet<String>(Arrays.asList(after));
        return this;
    }

    public Set<String> before() {
        return this.before;
    }

    public Set<String> after() {
        return this.after;
    }

    @Override
    public String toString() {
        return this.getName().getSingular();
    }

    public String toString(int flags) {
        return this.getName().toString(flags);
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (debug) {
            return String.valueOf(this.codeName) + " (" + this.c.getCanonicalName() + ")";
        }
        return this.getName().getSingular();
    }
}

