/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.aliases;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.aliases.MaterialName;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.localization.RegexMessage;
import ch.njol.skript.log.BlockingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.Utils;
import ch.njol.util.Pair;
import ch.njol.util.Setter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;

public abstract class Aliases {
    private static final HashMap<String, ItemType> aliases_english = new HashMap(2500);
    private static final HashMap<String, ItemType> aliases_localised = new HashMap(2500);
    private static final HashMap<Integer, MaterialName> materialNames_english = new HashMap(Material.values().length);
    private static final HashMap<Integer, MaterialName> materialNames_localised = new HashMap(Material.values().length);
    private static String itemSingular = "item";
    private static String itemPlural = "items";
    private static String itemGender = null;
    private static String blockSingular = "block";
    private static String blockPlural = "blocks";
    private static String blockGender = null;
    private static final ItemType everything = new ItemType();
    private static final Message m_brackets_error;
    private static final ArgsMessage m_empty_alias;
    private static final ArgsMessage m_unknown_variation;
    private static final Message m_starting_with_number;
    private static final Message m_missing_aliases;
    private static final Message m_empty_string;
    private static final ArgsMessage m_invalid_item_data;
    private static final ArgsMessage m_invalid_id;
    private static final Message m_invalid_block_data;
    private static final ArgsMessage m_invalid_item_type;
    private static final ArgsMessage m_out_of_data_range;
    private static final Message m_invalid_range;
    private static final ArgsMessage m_invalid_section;
    private static final ArgsMessage m_section_not_found;
    private static final ArgsMessage m_not_a_section;
    private static final Message m_unexpected_non_variation_section;
    private static final Message m_unexpected_section;
    private static final ArgsMessage m_loaded_x_aliases_from;
    private static final ArgsMessage m_loaded_x_aliases;
    private static final Pattern optionalGroupPattern;
    private static final Pattern groupPattern;
    private static final Pattern variationPattern;
    private static final Pattern numberWordPattern;
    private static final RegexMessage p_any;
    private static final Message m_any;
    private static final RegexMessage p_every;
    private static final RegexMessage p_of_every;
    private static final RegexMessage p_of;

    static {
        everything.setAll(true);
        everything.add(new ItemData());
        m_brackets_error = new Message("aliases.brackets error");
        m_empty_alias = new ArgsMessage("aliases.empty alias");
        m_unknown_variation = new ArgsMessage("aliases.unknown variation");
        m_starting_with_number = new Message("aliases.starting with number");
        m_missing_aliases = new Message("aliases.missing aliases");
        m_empty_string = new Message("aliases.empty string");
        m_invalid_item_data = new ArgsMessage("aliases.invalid item data");
        m_invalid_id = new ArgsMessage("aliases.invalid id");
        m_invalid_block_data = new Message("aliases.invalid block data");
        m_invalid_item_type = new ArgsMessage("aliases.invalid item type");
        m_out_of_data_range = new ArgsMessage("aliases.out of data range");
        m_invalid_range = new Message("aliases.invalid range");
        m_invalid_section = new ArgsMessage("aliases.invalid section");
        m_section_not_found = new ArgsMessage("aliases.section not found");
        m_not_a_section = new ArgsMessage("aliases.not a section");
        m_unexpected_non_variation_section = new Message("aliases.unexpected non-variation section");
        m_unexpected_section = new Message("aliases.unexpected section");
        m_loaded_x_aliases_from = new ArgsMessage("aliases.loaded x aliases from");
        m_loaded_x_aliases = new ArgsMessage("aliases.loaded x aliases");
        optionalGroupPattern = Pattern.compile("\\[([^\\[\\]]+?)\\]");
        groupPattern = Pattern.compile("\\(([^\\(\\)]+?)\\)");
        variationPattern = Pattern.compile("\\{([^\\{\\}]+?)\\}");
        numberWordPattern = Pattern.compile("\\d+\\s+.+");
        p_any = new RegexMessage("aliases.any", "", " (.+)", 2);
        m_any = new Message("aliases.any-skp");
        p_every = new RegexMessage("aliases.every", "", " (.+)", 2);
        p_of_every = new RegexMessage("aliases.of every", "(\\d+) ", " (.+)", 2);
        p_of = new RegexMessage("aliases.of", "(\\d+) (?:", " )?(.+)", 2);
    }

    private static final HashMap<String, ItemType> getAliases() {
        return Language.isUsingLocal() ? aliases_localised : aliases_english;
    }

    private static final ItemType getAlias_i(String s) {
        ItemType t = ScriptLoader.currentAliases.get(s);
        if (t != null) {
            return t;
        }
        return Aliases.getAliases().get(s);
    }

    private static final HashMap<Integer, MaterialName> getMaterialNames() {
        return Language.isUsingLocal() ? materialNames_localised : materialNames_english;
    }

    static LinkedHashMap<String, ItemType> getAliases(String name, ItemType value, Variations variations) {
        LinkedHashMap<String, ItemType> r = new LinkedHashMap<String, ItemType>();
        Matcher m = optionalGroupPattern.matcher(name);
        if (m.find()) {
            r.putAll(Aliases.getAliases(m.replaceFirst("$1"), value, variations));
            r.putAll(Aliases.getAliases(m.replaceFirst("").replace("  ", " ").trim(), value, variations));
        } else {
            m = groupPattern.matcher(name);
            if (m.find()) {
                String[] split = m.group(1).split("\\|", -1);
                if (split.length == 1) {
                    Skript.error(m_brackets_error.toString());
                }
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    r.putAll(Aliases.getAliases(m.replaceFirst(s).replace("  ", " ").trim(), value, variations));
                    ++n2;
                }
            } else {
                m = variationPattern.matcher(name);
                if (m.find()) {
                    if (variations.containsKey(m.group(1))) {
                        boolean hasDefault = false;
                        for (Map.Entry v : ((HashMap)variations.get(m.group(1))).entrySet()) {
                            String n;
                            if (((String)v.getKey()).equalsIgnoreCase("{default}")) {
                                hasDefault = true;
                                n = m.replaceFirst("").replace("  ", " ").trim();
                            } else {
                                String n0;
                                int c0;
                                int c = ((String)v.getKey()).lastIndexOf(64);
                                n = c == -1 ? m.replaceFirst((String)v.getKey()) : String.valueOf((c0 = (n0 = m.replaceFirst(((String)v.getKey()).substring(0, c).trim())).lastIndexOf(64)) == -1 ? n0 : n0.substring(0, c0).trim()) + ((String)v.getKey()).substring(c);
                            }
                            ItemType t = ((ItemType)v.getValue()).intersection(value);
                            if (t != null) {
                                r.putAll(Aliases.getAliases(n, t, variations));
                                continue;
                            }
                            Skript.warning(m_empty_alias.toString(n));
                        }
                        if (!hasDefault) {
                            r.putAll(Aliases.getAliases(m.replaceFirst("").replace("  ", " ").trim(), value, variations));
                        }
                    } else {
                        Skript.error(m_unknown_variation.toString(m.group(1)));
                    }
                } else if (name.contains("<any>")) {
                    String s = name.replace("<any>", m_any.toString());
                    int c = s.lastIndexOf(64);
                    if (c != -1) {
                        s = String.valueOf(s.substring(0, c + 1)) + "-";
                    }
                    r.putAll(Aliases.getAliases(s, value, variations));
                } else {
                    String[][] os = new String[][]{{"<item>", itemSingular, itemPlural, itemGender}, {"<block>", blockSingular, blockPlural, blockGender}, {"<item/block>", itemSingular, itemPlural, itemGender, blockSingular, blockPlural, blockGender}, {"<block/item>", blockSingular, blockPlural, blockGender, itemSingular, itemPlural, itemGender}};
                    boolean put = false;
                    String[][] stringArrayArray = os;
                    int n = os.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String[] o = stringArrayArray[n3];
                        if (name.contains(o[0])) {
                            int i = 1;
                            while (i < o.length) {
                                String s = name.replace(o[0], "\u00a6" + o[i] + "\u00a6" + o[i + 1] + "\u00a6");
                                if (o[i + 2] != null) {
                                    Pair<String, Integer> p = Noun.stripGender(s, s);
                                    s = String.valueOf((String)p.first) + "@" + o[i + 2];
                                }
                                r.put(s, value);
                                put = true;
                                i += 3;
                            }
                        }
                        ++n3;
                    }
                    if (!put) {
                        r.put(name, value);
                    }
                }
            }
        }
        r.remove("");
        return r;
    }

    static int addAliases(String name, String value, Variations variations) {
        ItemType t = Aliases.parseAlias(value);
        if (t == null) {
            return 0;
        }
        HashMap<String, ItemType> aliases = Aliases.getAliases();
        LinkedHashMap<String, ItemType> as = Aliases.getAliases(name.replaceAll("\\s+", " "), t, variations);
        boolean printedStartingWithNumberError = false;
        for (Map.Entry e : ((HashMap)as).entrySet()) {
            ItemType alias;
            ItemType si;
            String m;
            String s = ((String)e.getKey()).trim().replaceAll("\\s+", " ");
            Pair<String, Integer> g = Noun.stripGender(s, (String)e.getKey());
            Pair<String, String> p = Noun.getPlural((String)g.first);
            String lcs = ((String)p.first).toLowerCase();
            String lcp = ((String)p.second).toLowerCase();
            if (numberWordPattern.matcher(lcs).matches() || numberWordPattern.matcher(lcp).matches()) {
                if (printedStartingWithNumberError) continue;
                Skript.error(m_starting_with_number.toString());
                printedStartingWithNumberError = true;
                continue;
            }
            boolean b = lcs.endsWith(itemSingular);
            if (b || lcp.endsWith(itemPlural)) {
                m = (b ? lcs : lcp).substring(0, (b ? lcs : lcp).length() - (b ? itemSingular.length() : itemPlural.length()));
                if (m.endsWith(" ") || m.endsWith("-")) {
                    m = m.substring(0, m.length() - 1);
                }
                if ((si = aliases.get(m)) != null) {
                    si.setItem((ItemType)e.getValue());
                }
                alias = (ItemType)e.getValue();
            } else {
                b = lcs.endsWith(blockSingular);
                if (b || lcp.endsWith(blockPlural)) {
                    m = (b ? lcs : lcp).substring(0, (b ? lcs : lcp).length() - (b ? blockSingular.length() : blockPlural.length()));
                    if (m.endsWith(" ") || m.endsWith("-")) {
                        m = m.substring(0, m.length() - 1);
                    }
                    if ((si = aliases.get(m)) != null) {
                        si.setBlock((ItemType)e.getValue());
                    }
                    alias = (ItemType)e.getValue();
                } else {
                    ItemType[] ib = new ItemType[2];
                    String[] ibs = new String[]{itemSingular, blockSingular};
                    String[] seps = new String[]{" ", "", "-"};
                    int i = 0;
                    while (i < 2) {
                        String[] stringArray = seps;
                        int n = seps.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String sep = stringArray[n2];
                            ib[i] = aliases.get(String.valueOf(lcs) + sep + ibs[i]);
                            if (ib[i] != null) break;
                            ++n2;
                        }
                        ++i;
                    }
                    if (ib[0] == null && ib[1] == null) {
                        alias = (ItemType)e.getValue();
                    } else {
                        alias = ((ItemType)e.getValue()).clone();
                        alias.setItem(ib[0]);
                        alias.setBlock(ib[1]);
                    }
                }
            }
            aliases.put(lcs, alias);
            aliases.put(lcp, alias);
            HashMap<Integer, MaterialName> materialNames = Aliases.getMaterialNames();
            if (alias.getTypes().size() != 1) continue;
            ItemData d = alias.getTypes().get(0);
            MaterialName n = materialNames.get(d.getId());
            if (d.dataMin == -1 && d.dataMax == -1) {
                if (n != null) {
                    if (!n.singular.equals("" + d.getId()) || !n.singular.equals(n.plural)) continue;
                    n.singular = (String)p.first;
                    n.plural = (String)p.second;
                    continue;
                }
                materialNames.put(d.getId(), new MaterialName(d.getId(), (String)p.first, (String)p.second, (Integer)g.second));
                continue;
            }
            if (n == null) {
                n = new MaterialName(d.getId(), "" + d.getId(), "" + d.getId(), (Integer)g.second);
                materialNames.put(d.getId(), n);
            }
            n.names.put(new Pair<Short, Short>(d.dataMin, d.dataMax), p);
        }
        return as.size();
    }

    public static final String getMaterialName(int id, short data, int flags) {
        return Aliases.getMaterialName(id, data, data, flags);
    }

    public static final String getDebugMaterialName(int id, short data, int flags) {
        return Aliases.getDebugMaterialName(id, data, data, flags);
    }

    public static final String getMaterialName(int id, short dataMin, short dataMax, int flags) {
        MaterialName n = Aliases.getMaterialNames().get(id);
        if (n == null) {
            return "" + id;
        }
        return n.toString(dataMin, dataMax, flags);
    }

    public static final String getDebugMaterialName(int id, short dataMin, short dataMax, int flags) {
        MaterialName n = Aliases.getMaterialNames().get(id);
        if (n == null) {
            return id + ":" + dataMin + (dataMax == dataMin ? "" : "-" + dataMax);
        }
        return n.getDebugName(dataMin, dataMax, flags);
    }

    static final int addMissingMaterialNames() {
        Object m;
        HashMap<Integer, MaterialName> materialNames = Aliases.getMaterialNames();
        int r = 0;
        StringBuilder missing = new StringBuilder(m_missing_aliases + " ");
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            m = materialArray[n2];
            if (materialNames.get(m.getId()) == null) {
                materialNames.put(m.getId(), new MaterialName(m.getId(), m.toString().toLowerCase().replace('_', ' '), m.toString().toLowerCase().replace('_', ' '), 0));
                missing.append(String.valueOf(m.getId()) + ", ");
                ++r;
            }
            ++n2;
        }
        m = materialNames.get(-1);
        if (m == null) {
            materialNames.put(-1, new MaterialName(-1, Language.get("aliases.anything"), Language.get("aliases.anything"), 0));
            missing.append("<any>, ");
            ++r;
        }
        if (r > 0) {
            Skript.warning(missing.substring(0, missing.length() - 2));
        }
        return r;
    }

    public static ItemType parseAlias(String s) {
        String[] types;
        if (s == null || s.isEmpty()) {
            Skript.error(m_empty_string.toString());
            return null;
        }
        if (s.equals("*")) {
            return everything;
        }
        ItemType t = new ItemType();
        String[] stringArray = types = s.split("\\s*,\\s*");
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (Aliases.parseType(type, t, true) == null) {
                return null;
            }
            ++n2;
        }
        return t;
    }

    public static ItemType parseItemType(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        s = s.trim();
        ItemType t = new ItemType();
        Matcher m = p_of_every.getPattern().matcher(s);
        if (m.matches()) {
            t.setAmount(Utils.parseInt(m.group(1)));
            t.setAll(true);
            s = m.group(m.groupCount());
        } else {
            m = p_of.getPattern().matcher(s);
            if (m.matches()) {
                t.setAmount(Utils.parseInt(m.group(1)));
                s = m.group(m.groupCount());
            } else {
                m = p_every.getPattern().matcher(s);
                if (m.matches()) {
                    t.setAll(true);
                    s = m.group(m.groupCount());
                } else {
                    int l = s.length();
                    if ((s = Noun.stripIndefiniteArticle(s)).length() != l) {
                        t.setAmount(1);
                    }
                }
            }
        }
        String lc = s.toLowerCase();
        String of = Language.getSpaced("enchantments.of").toLowerCase();
        int c = -1;
        block3: while ((c = lc.indexOf(of, c + 1)) != -1) {
            String[] enchs;
            ItemType t2 = t.clone();
            BlockingLogHandler log = SkriptLogger.startLogHandler(new BlockingLogHandler());
            try {
                if (Aliases.parseType(s.substring(0, c), t2, false) == null) {
                    continue;
                }
            }
            finally {
                log.stop();
            }
            if (t2.numTypes() == 0) continue;
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            String[] stringArray = enchs = lc.substring(c + of.length(), lc.length()).split("\\s*(,|" + Language.get("and") + ")\\s*");
            int n = enchs.length;
            int n2 = 0;
            while (n2 < n) {
                String ench = stringArray[n2];
                EnchantmentType e = EnchantmentType.parse(ench);
                if (e == null) continue block3;
                enchantments.put(e.getType(), e.getLevel());
                ++n2;
            }
            t2.addEnchantments(enchantments);
            return t2;
        }
        if (Aliases.parseType(s, t, false) == null) {
            return null;
        }
        if (t.numTypes() == 0) {
            return null;
        }
        return t;
    }

    private static final ItemType parseType(String s, ItemType t, boolean isAlias) {
        int c = s.indexOf(58);
        if (c == -1) {
            c = s.length();
        }
        String type = s.substring(0, c);
        ItemData data = null;
        if (c != s.length() && (data = Aliases.parseData(s.substring(c + 1))) == null) {
            Skript.error(m_invalid_item_data.toString(s.substring(c)));
            return null;
        }
        if (type.isEmpty()) {
            t.add(data == null ? new ItemData() : data);
            return t;
        }
        if (type.matches("\\d+")) {
            ItemData d = new ItemData(Utils.parseInt(type));
            if (Material.getMaterial((int)d.getId()) == null) {
                Skript.error(m_invalid_id.toString(d.getId()));
                return null;
            }
            if (data != null) {
                if (d.getId() <= 255 && (data.dataMax > 15 || data.dataMin > 15)) {
                    Skript.error(m_invalid_block_data.toString());
                    return null;
                }
                d = d.intersection(data);
            }
            if (!isAlias) {
                Skript.warning("Using an ID instead of an alias is discouraged and will likely not be supported in future versions of Skript anymore. " + (d.toString().equals(type) ? "Please crate an alias for '" + type + (type.equals(s) ? "" : " or '" + s + "'") + "' (" + Material.getMaterial((int)d.getId()).name() + ") in aliases-english.sk or the script's aliases section and use that instead." : "Please replace '" + s + "' with e.g. '" + d.toString(true, 0) + "'."));
            }
            t.add(d);
            return t;
        }
        ItemType i = Aliases.getAlias(type);
        if (i != null) {
            for (ItemData d : i) {
                if (data != null) {
                    if (d.getId() <= 255 && (data.dataMax > 15 || data.dataMin > 15)) {
                        Skript.error(m_invalid_block_data.toString());
                        return null;
                    }
                    d = d.intersection(data);
                } else {
                    d = d.clone();
                }
                t.add(d);
            }
            if (data == null) {
                if (i.hasItem()) {
                    t.setItem(i.getItem().clone());
                }
                if (i.hasBlock()) {
                    t.setBlock(i.getBlock().clone());
                }
            }
            return t;
        }
        if (isAlias) {
            Skript.error(m_invalid_item_type.toString(s));
        }
        return null;
    }

    private static final ItemType getAlias(String s) {
        ItemType i;
        String lc = s.toLowerCase();
        Matcher m = p_any.getPattern().matcher(lc);
        if (m.matches()) {
            lc = m.group(m.groupCount());
        }
        if ((i = Aliases.getAlias_i(lc)) != null) {
            return i.clone();
        }
        return null;
    }

    private static final ItemData parseData(String s) {
        if (s.isEmpty()) {
            return new ItemData();
        }
        if (!s.matches("\\d+(-\\d+)?")) {
            return null;
        }
        ItemData t = new ItemData();
        int i = s.indexOf(45);
        if (i == -1) {
            i = s.length();
        }
        try {
            t.dataMin = Short.parseShort(s.substring(0, i));
            t.dataMax = i == s.length() ? t.dataMin : Short.parseShort(s.substring(i + 1, s.length()));
        }
        catch (NumberFormatException e) {
            Skript.error(m_out_of_data_range.toString((short)Short.MAX_VALUE));
            return null;
        }
        if (t.dataMin > t.dataMax) {
            Skript.error(m_invalid_range.toString());
            return null;
        }
        return t;
    }

    public static void clear() {
        aliases_english.clear();
        aliases_localised.clear();
        materialNames_english.clear();
        materialNames_localised.clear();
    }

    public static void load() {
        boolean wasLocal = Language.isUsingLocal();
        int l = 0;
        while (l < 2) {
            Config aliasConfig;
            Language.setUseLocal(l == 1);
            if (l == 1 && !Language.isUsingLocal()) break;
            try {
                File file = new File(Skript.getInstance().getDataFolder(), "aliases-" + Language.getName() + ".sk");
                if (!file.exists()) {
                    Skript.error("Could not find the " + Language.getName() + " aliases file " + file.getName());
                }
                aliasConfig = new Config(file, false, true, "=");
            }
            catch (IOException e) {
                Skript.error("Could not load the " + Language.getName() + " aliases config: " + e.getLocalizedMessage());
                return;
            }
            final ArrayList aliasNodes = new ArrayList();
            aliasConfig.validate(new SectionValidator().addEntry("aliases", new Setter<String>(){

                @Override
                public void set(String s) {
                    String[] stringArray = s.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String n3 = stringArray[n2];
                        aliasNodes.add(n3.trim());
                        ++n2;
                    }
                }
            }, false).addEntry("item", new Setter<String>(){

                @Override
                public void set(String s) {
                    Pair<String, Integer> g = Noun.stripGender(s, "item");
                    itemGender = Noun.getGenderID((Integer)g.second);
                    Pair<String, String> p = Noun.getPlural((String)g.first);
                    itemSingular = ((String)p.first).toLowerCase();
                    itemPlural = ((String)p.second).toLowerCase();
                }
            }, false).addEntry("block", new Setter<String>(){

                @Override
                public void set(String s) {
                    Pair<String, Integer> g = Noun.stripGender(s, "block");
                    blockGender = Noun.getGenderID((Integer)g.second);
                    Pair<String, String> p = Noun.getPlural((String)g.first);
                    blockSingular = ((String)p.first).toLowerCase();
                    blockPlural = ((String)p.second).toLowerCase();
                }
            }, false).setAllowUndefinedSections(true));
            for (Node node : aliasConfig.getMainNode()) {
                if (!(node instanceof SectionNode) || aliasNodes.contains(node.getKey())) continue;
                Skript.error(m_invalid_section.toString(node.getKey()));
            }
            Variations variations = new Variations();
            int num = 0;
            for (String an : aliasNodes) {
                Node node = aliasConfig.getMainNode().get(an);
                SkriptLogger.setNode(node);
                if (node == null) {
                    Skript.error(m_section_not_found.toString(an));
                    continue;
                }
                if (!(node instanceof SectionNode)) {
                    Skript.error(m_not_a_section.toString(an));
                    continue;
                }
                int i = 0;
                for (Node n : (SectionNode)node) {
                    if (n instanceof EntryNode) {
                        i += Aliases.addAliases((String)((EntryNode)n).getKey(), ((EntryNode)n).getValue(), variations);
                        continue;
                    }
                    if (!(n instanceof SectionNode)) continue;
                    if (!n.getKey().startsWith("{") || !n.getKey().endsWith("}")) {
                        Skript.error(m_unexpected_non_variation_section.toString());
                        continue;
                    }
                    HashMap<String, ItemType> vs = new HashMap<String, ItemType>();
                    for (Node a : (SectionNode)n) {
                        if (a instanceof SectionNode) {
                            Skript.error(m_unexpected_section.toString());
                            continue;
                        }
                        ItemType t = Aliases.parseAlias(((EntryNode)a).getValue());
                        if (t == null) continue;
                        vs.put(Noun.normalizePluralMarkers((String)((EntryNode)a).getKey()), t);
                    }
                    variations.put(n.getKey().substring(1, n.getKey().length() - 1), vs);
                }
                if (Skript.logVeryHigh()) {
                    Skript.info(m_loaded_x_aliases_from.toString(i, node.getKey()));
                }
                num += i;
            }
            SkriptLogger.setNode(null);
            if (Skript.logNormal()) {
                Skript.info(m_loaded_x_aliases.toString(num));
            }
            Aliases.addMissingMaterialNames();
            ++l;
        }
        Language.setUseLocal(wasLocal);
    }

    static final class Variations
    extends HashMap<String, HashMap<String, ItemType>> {
        private static final long serialVersionUID = -139481665727386819L;

        Variations() {
        }
    }
}

