/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.Updater;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EnumParser;
import ch.njol.skript.config.Option;
import ch.njol.skript.config.Section;
import ch.njol.skript.localization.Language;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Setter;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.event.EventPriority;

public abstract class SkriptConfig {
    static Config mainConfig;
    static Collection<Config> configs;
    static final Option<String> version;
    public static final Option<Boolean> keepConfigsLoaded;
    public static final Option<Boolean> enableEffectCommands;
    public static final Option<String> effectCommandToken;
    static final Option<Boolean> checkForNewVersion;
    static final Option<Timespan> updateCheckInterval;
    static final Option<Boolean> automaticallyDownloadNewVersion;
    public static final Option<Boolean> logPlayerCommands;
    public static final Option<Boolean> disableVariableConflictWarnings;
    public static final Option<Timespan> variableBackupInterval;
    private static final Option<DateFormat> dateFormat;
    public static final Option<Boolean> enableScriptCaching;
    public static final Option<EventPriority> defaultEventPriority;
    private static final Option<Verbosity> verbosity;
    public static final Option<String> language;
    public static final Option<Integer> maxTargetBlockDistance;
    public static final Option<Integer> numberAccuracy;
    public static final Section database;

    static {
        configs = new ArrayList<Config>();
        version = new Option<String>("version", String.class).optional(true).defaultValue(null);
        keepConfigsLoaded = new Option<Boolean>("keep configs loaded", Boolean.class).optional(true).defaultValue(false);
        enableEffectCommands = new Option<Boolean>("enable effect commands", Boolean.class).defaultValue(false);
        effectCommandToken = new Option<String>("effect command token", String.class).defaultValue("!");
        checkForNewVersion = new Option<Boolean>("check for new version", Boolean.class).defaultValue(false);
        updateCheckInterval = new Option<Timespan>("update check interval", Timespan.class).defaultValue(new Timespan(43200000L)).setter(new Setter<Timespan>(){

            @Override
            public void set(Timespan t) {
                if (t.getTicks() != 0 && Updater.checkerTask != null && !Updater.checkerTask.isAlive()) {
                    Updater.checkerTask.setNextExecution(t.getTicks());
                }
            }
        });
        automaticallyDownloadNewVersion = new Option<Boolean>("automatically download new version", Boolean.class).defaultValue(false);
        logPlayerCommands = new Option<Boolean>("log player commands", Boolean.class).defaultValue(false);
        disableVariableConflictWarnings = new Option<Boolean>("disable variable conflict warnings", Boolean.class).defaultValue(false);
        variableBackupInterval = new Option<Timespan>("variables backup interval", Timespan.class).defaultValue(new Timespan(0L)).setter(new Setter<Timespan>(){

            @Override
            public void set(Timespan t) {
                if (Variables.file.backupTask != null) {
                    if (t.getTicks() == 0) {
                        Variables.file.backupTask.cancel();
                    } else {
                        Variables.file.backupTask.setPeriod(t.getTicks());
                    }
                }
            }
        });
        dateFormat = new Option<DateFormat>("date format", new Converter<String, DateFormat>(){

            @Override
            public DateFormat convert(String s) {
                block3: {
                    try {
                        if (!s.equalsIgnoreCase("default")) break block3;
                        return null;
                    }
                    catch (IllegalArgumentException e) {
                        Skript.error("'" + s + "' is not a valid date format. Please refer to http://docs.oracle.com/javase/6/docs/api/java/text/SimpleDateFormat.html for instructions on the format.");
                        return null;
                    }
                }
                return new SimpleDateFormat(s);
            }
        }).defaultValue(DateFormat.getDateTimeInstance(3, 3));
        enableScriptCaching = new Option<Boolean>("enable script caching", Boolean.class).optional(true).defaultValue(false);
        defaultEventPriority = new Option<EventPriority>("plugin priority", new Converter<String, EventPriority>(){

            @Override
            public EventPriority convert(String s) {
                try {
                    return EventPriority.valueOf((String)s.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    Skript.error("The plugin priority has to be one of lowest, low, normal, high, or highest.");
                    return null;
                }
            }
        }).defaultValue(EventPriority.NORMAL);
        verbosity = new Option<Verbosity>("verbosity", new EnumParser<Verbosity>(Verbosity.class, "verbosity")).defaultValue(Verbosity.NORMAL).setter(new Setter<Verbosity>(){

            @Override
            public void set(Verbosity v) {
                SkriptLogger.setVerbosity(v);
            }
        });
        language = new Option<String>("language", String.class).optional(true).setter(new Setter<String>(){

            @Override
            public void set(String s) {
                if (!Language.load(s)) {
                    Skript.error("No language file found for '" + s + "'!");
                }
            }
        });
        maxTargetBlockDistance = new Option<Integer>("maximum target block distance", Integer.class).defaultValue(100);
        numberAccuracy = new Option<Integer>("number accuracy", Integer.class).defaultValue(2);
        database = new Section("database"){
            private final Option<String> type = new Option<String>("type", String.class);
            private final Option<String> pattern = new Option<String>("pattern", String.class);
            private final Option<Boolean> monitor_changes = new Option<Boolean>("monitor changes", Boolean.class);
            private final Option<Timespan> monitor_interval = new Option<Timespan>("monitor interval", Timespan.class);
            private final Option<String> host = new Option<String>("host", String.class);
            private final Option<Integer> port = new Option<Integer>("port", Integer.class);
            private final Option<String> user = new Option<String>("user", String.class);
            private final Option<String> password = new Option<String>("password", String.class);
            private final Option<String> database = new Option<String>("database", String.class);
            private final Option<String> file = new Option<String>("file", String.class);
        };
    }

    private SkriptConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String formatDate(long timestamp) {
        DateFormat f;
        DateFormat dateFormat = f = SkriptConfig.dateFormat.value();
        synchronized (dateFormat) {
            return f.format(timestamp);
        }
    }

    static boolean load() {
        File config;
        block17: {
            block16: {
                try {
                    File oldConfig = new File(Skript.getInstance().getDataFolder(), "config.cfg");
                    config = new File(Skript.getInstance().getDataFolder(), "config.sk");
                    if (oldConfig.exists()) {
                        if (!config.exists()) {
                            oldConfig.renameTo(config);
                            Skript.info("[1.3] Renamed your 'config.cfg' to 'config.sk' to match the new format");
                        } else {
                            Skript.error("Found both a new and an old config, ingoring the old one");
                        }
                    }
                    if (config.exists()) break block16;
                    Skript.error("Config file 'config.sk' does not exist! Please make sure that you downloaded the .zip file (i.e. not the .jar) from Skript's BukkitDev page and extracted it correctly.");
                    return false;
                }
                catch (Exception e) {
                    Skript.exception((Throwable)e, "An error occurred while loading the config");
                    return false;
                }
            }
            if (config.canRead()) break block17;
            Skript.error("Config file 'config.sk' cannot be read!");
            return false;
        }
        try {
            mainConfig = new Config(config, false, false, ":");
        }
        catch (IOException e) {
            Skript.error("Could not load the main config: " + e.getLocalizedMessage());
            return false;
        }
        if (!Skript.getVersion().toString().equals(mainConfig.get(SkriptConfig.version.key))) {
            try {
                Config newConfig = new Config(Skript.getInstance().getResource("config.sk"), "Skript.jar/config.sk", false, false, ":");
                if (newConfig.setValues(mainConfig)) {
                    File bu = FileUtils.backup(config);
                    mainConfig = newConfig;
                    mainConfig.getMainNode().set("version", Skript.getVersion().toString());
                    mainConfig.save(config);
                    Skript.info("Your configuration has been updated to the latest version. A backup of your old config file has been created as " + bu.getName());
                } else {
                    mainConfig.getMainNode().set("version", Skript.getVersion().toString());
                    mainConfig.save(config);
                }
            }
            catch (IOException e) {
                Skript.error("Could not load the new config from the jar file: " + e.getLocalizedMessage());
            }
        }
        mainConfig.load(SkriptConfig.class);
        if (!keepConfigsLoaded.value().booleanValue()) {
            mainConfig = null;
        }
        return true;
    }
}

