/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.Updater;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.PluralizingArgsMessage;
import ch.njol.skript.log.RedirectingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.CommandHelp;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.util.ChatPaginator;

public class SkriptCommand
implements CommandExecutor {
    private static final String NODE = "skript command";
    private static final CommandHelp skriptCommandHelp = new CommandHelp("<gray>/<gold>skript", ChatColor.AQUA, "skript command.help").add(new CommandHelp("reload", ChatColor.DARK_RED).add("all").add("config").add("aliases").add("scripts").add("<script>")).add(new CommandHelp("enable", ChatColor.DARK_RED).add("all").add("<script>")).add(new CommandHelp("disable", ChatColor.DARK_RED).add("all").add("<script>")).add(new CommandHelp("update", ChatColor.DARK_RED).add("check").add("changes").add("download")).add("help");
    private static final ArgsMessage m_reloading = new ArgsMessage("skript command.reload.reloading");
    private static final ArgsMessage m_reloaded = new ArgsMessage("skript command.reload.reloaded");
    private static final ArgsMessage m_reload_error = new ArgsMessage("skript command.reload.error");
    private static final ArgsMessage m_invalid_script = new ArgsMessage("skript command.invalid script");
    private static final ArgsMessage m_invalid_folder = new ArgsMessage("skript command.invalid folder");
    private static /* synthetic */ int[] $SWITCH_TABLE$ch$njol$skript$Updater$UpdateState;

    private static final void reloading(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command.reload." + what) : Language.format("skript command.reload." + what, args);
        Skript.info(sender, StringUtils.fixCapitalization(m_reloading.toString(what)));
    }

    private static final void reloaded(CommandSender sender, RedirectingLogHandler r, String what, Object ... args) {
        String string = what = args.length == 0 ? Language.get("skript command.reload." + what) : PluralizingArgsMessage.format(Language.format("skript command.reload." + what, args));
        if (r.numErrors() == 0) {
            Skript.info(sender, StringUtils.fixCapitalization(PluralizingArgsMessage.format(m_reloaded.toString(what))));
        } else {
            Skript.error(sender, StringUtils.fixCapitalization(PluralizingArgsMessage.format(m_reload_error.toString(what, r.numErrors()))));
        }
    }

    private static final void info(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command." + what) : PluralizingArgsMessage.format(Language.format("skript command." + what, args));
        Skript.info(sender, StringUtils.fixCapitalization(what));
    }

    private static final void message(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command." + what) : PluralizingArgsMessage.format(Language.format("skript command." + what, args));
        Skript.message(sender, StringUtils.fixCapitalization(what));
    }

    private static final void error(CommandSender sender, String what, Object ... args) {
        what = args.length == 0 ? Language.get("skript command." + what) : PluralizingArgsMessage.format(Language.format("skript command." + what, args));
        Skript.error(sender, StringUtils.fixCapitalization(what));
    }

    /*
     * Unable to fully structure code
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block106: {
            if (!SkriptCommand.skriptCommandHelp.test(sender, args)) {
                return true;
            }
            r = SkriptLogger.startLogHandler(new RedirectingLogHandler(sender, ""));
            try {
                block107: {
                    block108: {
                        if (args[0].equalsIgnoreCase("reload")) {
                            if (args[1].equalsIgnoreCase("all")) {
                                SkriptCommand.reloading(sender, "config and scripts", new Object[0]);
                                Skript.reload();
                                SkriptCommand.reloaded(sender, r, "config and scripts", new Object[0]);
                            } else if (args[1].equalsIgnoreCase("scripts")) {
                                SkriptCommand.reloading(sender, "scripts", new Object[0]);
                                Skript.reloadScripts();
                                SkriptCommand.reloaded(sender, r, "scripts", new Object[0]);
                            } else if (args[1].equalsIgnoreCase("config")) {
                                SkriptCommand.reloading(sender, "main config", new Object[0]);
                                Skript.reloadMainConfig();
                                SkriptCommand.reloaded(sender, r, "main config", new Object[0]);
                            } else if (args[1].equalsIgnoreCase("aliases")) {
                                SkriptCommand.reloading(sender, "aliases", new Object[0]);
                                Skript.reloadAliases();
                                SkriptCommand.reloaded(sender, r, "aliases", new Object[0]);
                            } else {
                                f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                                if (f == null) lbl-1000:
                                // 2 sources

                                {
                                    return true;
                                }
                                if (!f.isDirectory()) {
                                    if (f.getName().startsWith("-")) {
                                        SkriptCommand.info(sender, "reload.script disabled", new Object[]{f.getName().substring(1)});
                                        ** continue;
                                    }
                                    SkriptCommand.reloading(sender, "script", new Object[]{f.getName()});
                                    ScriptLoader.unloadScript(f);
                                    ScriptLoader.loadScripts(new File[]{f});
                                    SkriptCommand.reloaded(sender, r, "script", new Object[]{f.getName()});
                                } else {
                                    SkriptCommand.reloading(sender, "scripts in folder", new Object[]{f.getName()});
                                    disabled = ScriptLoader.unloadScripts((File)f).files;
                                    enabled = ScriptLoader.loadScripts((File)f).files;
                                    if (Math.max(disabled, enabled) == 0) {
                                        SkriptCommand.info(sender, "reload.empty folder", new Object[]{f.getName()});
                                    } else {
                                        SkriptCommand.reloaded(sender, r, "x scripts in folder", new Object[]{f.getName(), Math.max(disabled, enabled)});
                                    }
                                }
                            }
                            break block106;
                        }
                        if (args[0].equalsIgnoreCase("enable")) {
                            if (args[1].equals("all")) {
                                try {
                                    SkriptCommand.info(sender, "enable.all.enabling", new Object[0]);
                                    files = SkriptCommand.toggleScripts(new File(Skript.getInstance().getDataFolder(), "scripts"), true);
                                    ScriptLoader.loadScripts(files.toArray(new File[0]));
                                    if (r.numErrors() == 0) {
                                        SkriptCommand.info(sender, "enable.all.enabled", new Object[0]);
                                        break block106;
                                    }
                                    SkriptCommand.error(sender, "enable.all.error", new Object[]{r.numErrors()});
                                }
                                catch (IOException e) {
                                    SkriptCommand.error(sender, "enable.all.io error", new Object[]{ExceptionUtils.toString(e)});
                                }
                                break block106;
                            }
                            f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                            if (f == null) {
                                return true;
                            }
                            if (!f.isDirectory()) {
                                if (!f.getName().startsWith("-")) {
                                    SkriptCommand.info(sender, "enable.single.already enabled", new Object[]{f.getName(), StringUtils.join(args, " ", 1, args.length)});
                                    return true;
                                }
                                try {
                                    f = FileUtils.move(f, new File(f.getParentFile(), f.getName().substring(1)), false);
                                }
                                catch (IOException e) {
                                    SkriptCommand.error(sender, "enable.single.io error", new Object[]{f.getName().substring(1), ExceptionUtils.toString(e)});
                                    r.stop();
                                    return true;
                                }
                                SkriptCommand.info(sender, "enable.single.enabling", new Object[]{f.getName()});
                                ScriptLoader.loadScripts(new File[]{f});
                                if (r.numErrors() == 0) {
                                    SkriptCommand.info(sender, "enable.single.enabled", new Object[]{f.getName()});
                                } else {
                                    SkriptCommand.error(sender, "enable.single.error", new Object[]{f.getName(), r.numErrors()});
                                }
                                return true;
                            }
                            try {
                                scripts = SkriptCommand.toggleScripts(f, true);
                            }
                            catch (IOException e) {
                                SkriptCommand.error(sender, "enable.folder.io error", new Object[]{f.getName(), ExceptionUtils.toString(e)});
                                r.stop();
                                return true;
                            }
                            if (scripts.isEmpty()) {
                                SkriptCommand.info(sender, "enable.folder.empty", new Object[]{f.getName()});
                                return true;
                            }
                            SkriptCommand.info(sender, "enable.folder.enabling", new Object[]{f.getName(), scripts.size()});
                            i = ScriptLoader.loadScripts(scripts.toArray(new File[scripts.size()]));
                            if (!SkriptCommand.$assertionsDisabled && i.files != scripts.size()) {
                                throw new AssertionError();
                            }
                            if (r.numErrors() == 0) {
                                SkriptCommand.info(sender, "enable.folder.enabled", new Object[]{f.getName(), i.files});
                            } else {
                                SkriptCommand.error(sender, "enable.folder.error", new Object[]{f.getName(), r.numErrors()});
                            }
                            return true;
                        }
                        if (args[0].equalsIgnoreCase("disable")) {
                            if (args[1].equals("all")) {
                                Skript.disableScripts();
                                try {
                                    SkriptCommand.toggleScripts(new File(Skript.getInstance().getDataFolder(), "scripts"), false);
                                    SkriptCommand.info(sender, "disable.all.disabled", new Object[0]);
                                }
                                catch (IOException e) {
                                    SkriptCommand.error(sender, "disable.all.io error", new Object[]{ExceptionUtils.toString(e)});
                                }
                                break block106;
                            }
                            f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                            if (f == null) {
                                return true;
                            }
                            if (!f.isDirectory()) {
                                if (f.getName().startsWith("-")) {
                                    SkriptCommand.info(sender, "disable.single.already disabled", new Object[]{f.getName().substring(1)});
                                    return true;
                                }
                                ScriptLoader.unloadScript(f);
                                try {
                                    FileUtils.move(f, new File(f.getParentFile(), "-" + f.getName()), false);
                                }
                                catch (IOException e) {
                                    SkriptCommand.error(sender, "disable.single.io error", new Object[]{f.getName(), ExceptionUtils.toString(e)});
                                    r.stop();
                                    return true;
                                }
                                SkriptCommand.info(sender, "disable.single.disabled", new Object[]{f.getName()});
                                return true;
                            }
                            try {
                                scripts = SkriptCommand.toggleScripts(f, false);
                            }
                            catch (IOException e) {
                                SkriptCommand.error(sender, "disable.folder.io error", new Object[]{f.getName(), ExceptionUtils.toString(e)});
                                r.stop();
                                return true;
                            }
                            if (scripts.isEmpty()) {
                                SkriptCommand.info(sender, "disable.folder.empty", new Object[]{f.getName()});
                                return true;
                            }
                            for (File script : scripts) {
                                ScriptLoader.unloadScript(new File(script.getParentFile(), script.getName().substring(1)));
                            }
                            SkriptCommand.info(sender, "disable.folder.disabled", new Object[]{f.getName(), scripts.size()});
                            return true;
                        }
                        if (!args[0].equalsIgnoreCase("update")) ** GOTO lbl266
                        Updater.stateLock.writeLock().lock();
                        state = Updater.state;
                        if (args[1].equals("check")) {
                            switch (SkriptCommand.$SWITCH_TABLE$ch$njol$skript$Updater$UpdateState()[state.ordinal()]) {
                                case 1: {
                                    Updater.check(sender, false, false);
                                    break;
                                }
                                case 2: {
                                    Skript.info(sender, "" + Updater.m_check_in_progress);
                                    break;
                                }
                                case 3: {
                                    Updater.check(sender, false, false);
                                    break;
                                }
                                case 4: {
                                    if (Updater.latest.get() == null) {
                                        Skript.info(sender, Skript.getVersion().isStable() != false ? "" + Updater.m_running_latest_version : "" + Updater.m_running_latest_version_beta);
                                        break;
                                    }
                                    Skript.info(sender, "" + Updater.m_update_available);
                                    break;
                                }
                                case 5: {
                                    Skript.info(sender, "" + Updater.m_download_in_progress);
                                    break;
                                }
                                case 6: {
                                    Skript.info(sender, "" + Updater.m_download_error);
                                    break;
                                }
                                case 7: {
                                    Skript.info(sender, "" + Updater.m_downloaded);
                                }
                            }
                            break block106;
                        }
                        if (!args[1].equalsIgnoreCase("changes")) ** GOTO lbl235
                        if (state == Updater.UpdateState.NOT_STARTED) {
                            Skript.info(sender, "" + Updater.m_not_started);
                            break block106;
                        }
                        if (state == Updater.UpdateState.CHECK_IN_PROGRESS) {
                            Skript.info(sender, "" + Updater.m_check_in_progress);
                            break block106;
                        }
                        if (state == Updater.UpdateState.CHECK_ERROR) {
                            Skript.info(sender, "" + Updater.m_check_error);
                            break block106;
                        }
                        if (Updater.latest.get() == null) {
                            Skript.info(sender, Skript.getVersion().isStable() != false ? "" + Updater.m_running_latest_version : "" + Updater.m_running_latest_version_beta);
                            break block106;
                        }
                        if (args.length == 2 && Updater.infos.size() != 1) {
                            SkriptCommand.info(sender, "update.changes.multiple versions.title", new Object[]{Updater.infos.size(), Skript.getVersion()});
                            versions = Updater.infos.get((int)0).version.toString();
                            i = Updater.infos.size() - 1;
                            while (i >= 0) {
                                versions = String.valueOf(versions) + ", " + Updater.infos.get((int)i).version.toString();
                                --i;
                            }
                            Skript.message(sender, "  " + versions);
                            SkriptCommand.message(sender, "update.changes.multiple versions.footer", new Object[0]);
                            break block106;
                        }
                        info = null;
                        pageNum = 1;
                        if (Updater.infos.size() != 1) break block108;
                        info = Updater.latest.get();
                        if (args.length >= 3 && args[2].matches("\\d+")) {
                            pageNum = Utils.parseInt(args[2]);
                        }
                        ** GOTO lbl229
                    }
                    version = args[2];
                    for (Updater.VersionInfo i : Updater.infos) {
                        if (!i.version.toString().equals(version)) continue;
                        info = i;
                        break;
                    }
                    if (info != null) break block107;
                    SkriptCommand.error(sender, "update.changes.invalid version", new Object[]{version});
                    Updater.stateLock.writeLock().unlock();
                    return true;
                    {
                        catch (Throwable var12_29) {
                            throw var12_29;
                        }
                    }
                }
                try {
                    try {
                        if (args.length >= 4 && args[3].matches("\\d+")) {
                            pageNum = Utils.parseInt(args[3]);
                        }
lbl229:
                        // 4 sources

                        page = ChatPaginator.paginate((String)info.changelog, (int)pageNum, (int)55, (int)8);
                        SkriptCommand.info(sender, "update.changes.title", new Object[]{info.version, info.date, pageNum, page.getTotalPages()});
                        sender.sendMessage(page.getLines());
                        if (pageNum < page.getTotalPages()) {
                            SkriptCommand.message(sender, "update.changes.next page", new Object[]{String.valueOf(Updater.infos.size() == 1 ? "" : info.version + " ") + (pageNum + 1)});
                        }
                        break block106;
lbl235:
                        // 1 sources

                        if (args[1].equalsIgnoreCase("download")) {
                            switch (SkriptCommand.$SWITCH_TABLE$ch$njol$skript$Updater$UpdateState()[state.ordinal()]) {
                                case 1: {
                                    Updater.check(sender, true, false);
                                    break;
                                }
                                case 2: {
                                    Skript.info(sender, "" + Updater.m_check_in_progress);
                                    break;
                                }
                                case 3: {
                                    Updater.check(sender, true, false);
                                    break;
                                }
                                case 4: {
                                    if (Updater.latest.get() == null) {
                                        Skript.info(sender, Skript.getVersion().isStable() != false ? "" + Updater.m_running_latest_version : "" + Updater.m_running_latest_version_beta);
                                        break;
                                    }
                                    Updater.download(sender, false);
                                    break;
                                }
                                case 5: {
                                    Skript.info(sender, "" + Updater.m_download_in_progress);
                                    break;
                                }
                                case 7: {
                                    Skript.info(sender, "" + Updater.m_downloaded);
                                    break;
                                }
                                case 6: {
                                    Updater.download(sender, false);
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                        break block106;
                    }
                    finally {
                        Updater.stateLock.writeLock().unlock();
                    }
lbl266:
                    // 1 sources

                    if (args[0].equalsIgnoreCase("help")) {
                        SkriptCommand.skriptCommandHelp.showHelp(sender);
                    }
                }
                catch (Exception e) {
                    Skript.exception((Throwable)e, new String[]{"Exception occurred in Skript's main command", "Used command: /" + label + " " + StringUtils.join(args, " ")});
                }
            }
            finally {
                r.stop();
            }
        }
        return true;
    }

    private static File getScriptFromArgs(CommandSender sender, String[] args, int start) {
        File f;
        boolean isFolder;
        String script = StringUtils.join(args, " ", start, args.length);
        boolean bl = isFolder = script.endsWith("/") || script.endsWith("\\");
        if (isFolder) {
            script = script.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        } else if (!StringUtils.endsWithIgnoreCase(script, ".sk")) {
            script = String.valueOf(script) + ".sk";
        }
        if (script.startsWith("-")) {
            script = script.substring(1);
        }
        if (!(f = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator + script)).exists() && !(f = new File(f.getParentFile(), "-" + f.getName())).exists()) {
            Skript.error(sender, (isFolder ? m_invalid_folder : m_invalid_script).toString(script));
            return null;
        }
        return f;
    }

    private static final Collection<File> toggleScripts(File folder, final boolean enable) throws IOException {
        return FileUtils.renameAll(folder, new Converter<String, String>(){

            @Override
            public String convert(String name) {
                if (StringUtils.endsWithIgnoreCase(name, ".sk") && name.startsWith("-") == enable) {
                    return enable ? name.substring(1) : "-" + name;
                }
                return null;
            }
        });
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ch$njol$skript$Updater$UpdateState() {
        if ($SWITCH_TABLE$ch$njol$skript$Updater$UpdateState != null) {
            return $SWITCH_TABLE$ch$njol$skript$Updater$UpdateState;
        }
        int[] nArray = new int[Updater.UpdateState.values().length];
        try {
            nArray[Updater.UpdateState.CHECKED_FOR_UPDATE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.CHECK_ERROR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.CHECK_IN_PROGRESS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.DOWNLOADED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.DOWNLOAD_ERROR.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.DOWNLOAD_IN_PROGRESS.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.NOT_STARTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ch$njol$skript$Updater$UpdateState = nArray;
        return nArray;
    }
}

