/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Conditional;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.While;
import ch.njol.skript.localization.Language;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.ErrorDescLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Callback;
import ch.njol.util.CollectionUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.bukkit.event.Event;

public final class ScriptLoader {
    public static Config currentScript = null;
    public static String currentEventName = null;
    public static SkriptEvent currentEvent = null;
    public static Class<? extends Event>[] currentEvents = null;
    public static List<TriggerSection> currentSections = new ArrayList<TriggerSection>();
    public static List<Loop> currentLoops = new ArrayList<Loop>();
    public static final Map<String, ItemType> currentAliases = new HashMap<String, ItemType>();
    public static final HashMap<String, String> currentOptions = new HashMap();
    private static final ScriptInfo loadedScripts = new ScriptInfo();
    public static Kleenean hasDelayBefore = Kleenean.FALSE;
    private static String indentation = "";
    private static final FileFilter scriptFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return (f.isDirectory() || StringUtils.endsWithIgnoreCase(f.getName(), ".sk")) && !f.getName().startsWith("-");
        }
    };

    private ScriptLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScriptInfo loadScripts() {
        ScriptInfo i;
        File scriptsFolder = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator);
        if (!scriptsFolder.isDirectory()) {
            scriptsFolder.mkdirs();
        }
        Language.setUseLocal(false);
        try {
            Date start = new Date();
            ErrorDescLogHandler h = SkriptLogger.startLogHandler(new ErrorDescLogHandler(null, null, "All scripts loaded without errors!"));
            try {
                i = ScriptLoader.loadScripts(scriptsFolder);
                ScriptInfo scriptInfo = loadedScripts;
                synchronized (scriptInfo) {
                    loadedScripts.add(i);
                }
            }
            finally {
                h.stop();
            }
            if (i.files == 0) {
                Skript.warning("No scripts were found, maybe you should write some ;)");
            }
            if (Skript.logNormal() && i.files > 0) {
                Skript.info("loaded " + i.files + " script" + (i.files == 1 ? "" : "s") + " with a total of " + i.triggers + " trigger" + (i.triggers == 1 ? "" : "s") + " and " + i.commands + " command" + (i.commands == 1 ? "" : "s") + " in " + start.difference(new Date()));
            }
        }
        finally {
            Language.setUseLocal(true);
        }
        SkriptEventHandler.registerBukkitEvents();
        return i;
    }

    public static final ScriptInfo loadScripts(File directory) {
        ScriptInfo i = new ScriptInfo();
        boolean wasLocal = Language.setUseLocal(false);
        try {
            Object[] files = directory.listFiles(scriptFilter);
            Arrays.sort(files);
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object f = objectArray[n2];
                if (((File)f).isDirectory()) {
                    i.add(ScriptLoader.loadScripts((File)f));
                } else {
                    i.add(ScriptLoader.loadScript((File)f));
                }
                ++n2;
            }
        }
        finally {
            if (wasLocal) {
                Language.setUseLocal(true);
            }
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ScriptInfo loadScripts(File[] files) {
        Arrays.sort(files);
        ScriptInfo i = new ScriptInfo();
        boolean wasLocal = Language.setUseLocal(false);
        try {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                i.add(ScriptLoader.loadScript(f));
                ++n2;
            }
        }
        finally {
            if (wasLocal) {
                Language.setUseLocal(true);
            }
        }
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            loadedScripts.add(i);
        }
        SkriptEventHandler.registerBukkitEvents();
        return i;
    }

    /*
     * Unable to fully structure code
     */
    private static final ScriptInfo loadScript(File f) {
        cache = null;
        if (SkriptConfig.enableScriptCaching.value().booleanValue() && (cache = new File(f.getParentFile(), "cache" + File.separator + f.getName() + "c")).exists()) {
            block72: {
                log = SkriptLogger.startRetainingLog();
                in = null;
                in = new ObjectInputStream(new FileInputStream(cache));
                lastModified = in.readLong();
                if (lastModified != f.lastModified()) break block72;
                script = (SerializedScript)in.readObject();
                block32: for (Trigger t : script.triggers) {
                    if (t.getEvent() instanceof SelfRegisteringSkriptEvent) {
                        ((SelfRegisteringSkriptEvent)t.getEvent()).register(t);
                        SkriptEventHandler.addSelfRegisteringTrigger(t);
                        continue;
                    }
                    for (SkriptEventInfo<?> e : Skript.getEvents()) {
                        if (e.c != t.getEvent().getClass()) continue;
                        SkriptEventHandler.addTrigger(e.events, t);
                        continue block32;
                    }
                    throw new EmptyStackException();
                }
                for (ScriptCommand c : script.commands) {
                    Commands.registerCommand(c);
                }
                log.printLog();
                var12_23 = new ScriptInfo(1, script.triggers.size(), script.commands.size());
                log.stop();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException var13_25) {
                        // empty catch block
                    }
                }
                return var12_23;
            }
            try {
                try {
                    cache.delete();
                }
                catch (Exception e) {
                    if (Skript.testing()) {
                        System.err.println("[debug] Error loading cached script '" + f.getName() + "':");
                        e.printStackTrace();
                    }
                    ScriptLoader.unloadScript(f);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException var5_30) {
                            // empty catch block
                        }
                    }
                    cache.delete();
                    log.stop();
                    if (in == null) ** GOTO lbl77
                    try {
                        in.close();
                    }
                    catch (IOException var13_26) {}
                }
            }
            catch (Throwable var11_32) {
                log.stop();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException var13_27) {
                        // empty catch block
                    }
                }
                throw var11_32;
            }
            log.stop();
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException var13_28) {
                    // empty catch block
                }
            }
        }
lbl77:
        // 9 sources

        try {
            block75: {
                config = new Config(f, true, false, ":");
                if (SkriptConfig.keepConfigsLoaded.value().booleanValue()) {
                    SkriptConfig.configs.add(config);
                }
                numTriggers = 0;
                numCommands = 0;
                ScriptLoader.currentAliases.clear();
                ScriptLoader.currentOptions.clear();
                ScriptLoader.currentScript = config;
                script = new SerializedScript();
                numErrors = SkriptLogger.startLogHandler(new CountingLogHandler(Level.SEVERE));
                try {
                    for (Node cnode : config.getMainNode()) {
                        if (!(cnode instanceof SectionNode)) {
                            Skript.error("invalid line - all code has to be put into triggers");
                            continue;
                        }
                        node = (SectionNode)cnode;
                        event = node.getKey();
                        if (event.equalsIgnoreCase("aliases")) {
                            node.convertToEntries(0, "=");
                            for (Node n : node) {
                                if (!(n instanceof EntryNode)) {
                                    Skript.error("invalid line in alias section");
                                    continue;
                                }
                                t = Aliases.parseAlias(((EntryNode)n).getValue());
                                if (t == null) continue;
                                ScriptLoader.currentAliases.put(((EntryNode)n).getKey().toLowerCase(), t);
                            }
                            continue;
                        }
                        if (event.equalsIgnoreCase("options")) {
                            node.convertToEntries(0);
                            for (Node n : node) {
                                if (!(n instanceof EntryNode)) {
                                    Skript.error("invalid line in options");
                                    continue;
                                }
                                ScriptLoader.currentOptions.put((String)((EntryNode)n).getKey(), ((EntryNode)n).getValue());
                            }
                            continue;
                        }
                        if (event.equalsIgnoreCase("variables")) {
                            node.convertToEntries(0, "=");
                            for (Node n : node) {
                                if (!(n instanceof EntryNode)) {
                                    Skript.error("Invalid line in variables section");
                                    continue;
                                }
                                name = ((EntryNode)n).getKey().toLowerCase(Locale.ENGLISH);
                                if (name.startsWith("{") && name.endsWith("}")) {
                                    name = name.substring(1, name.length() - 1);
                                }
                                if ((name = StringUtils.replaceAll((CharSequence)name, "%(.+)?%", new Callback<String, Matcher>(var = name){
                                    private final /* synthetic */ String val$var;
                                    {
                                        this.val$var = string;
                                    }

                                    @Override
                                    public String run(Matcher m) {
                                        if (m.group(1).contains("{") || m.group(1).contains("}") || m.group(1).contains("%")) {
                                            Skript.error("'" + this.val$var + "' is not a valid name for a default variable");
                                            return null;
                                        }
                                        ClassInfo<?> ci = Classes.getClassInfoFromUserInput(m.group(1));
                                        if (ci == null) {
                                            Skript.error("Can't understand the type '" + m.group(1) + "'");
                                            return null;
                                        }
                                        return "<" + ci.getCodeName() + ">";
                                    }
                                })) == null) continue;
                                if (name.contains("%")) {
                                    Skript.error("Invalid use of percent signs in variable name");
                                    continue;
                                }
                                if (Variables.getVariable(name) != null) continue;
                                log = SkriptLogger.startParseLogHandler();
                                o = Classes.parseSimple(((EntryNode)n).getValue(), Object.class, ParseContext.CONFIG);
                                log.stop();
                                if (o == null) {
                                    log.printError("Can't understand the value '" + ((EntryNode)n).getValue() + "'");
                                    continue;
                                }
                                ci = Classes.getSuperClassInfo(o.getClass());
                                if (ci.getSerializer() == null) {
                                    Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                                    continue;
                                }
                                if (ci.getSerializeAs() != null && (o = Converters.convert(o, (as = Classes.getExactClassInfo(ci.getSerializeAs())).getC())) == null) {
                                    Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                                    continue;
                                }
                                Variables.setVariable(name, o);
                            }
                            continue;
                        }
                        if (!SkriptParser.validateLine(event)) continue;
                        if (event.toLowerCase().startsWith("command ")) {
                            ScriptLoader.currentEvent = null;
                            ScriptLoader.currentEventName = "command";
                            ScriptLoader.currentEvents = CollectionUtils.array(new Class[]{CommandEvent.class});
                            ScriptLoader.hasDelayBefore = Kleenean.FALSE;
                            c = Commands.loadCommand(node);
                            if (c != null) {
                                ++numCommands;
                                script.commands.add(c);
                            }
                            ScriptLoader.currentEvent = null;
                            ScriptLoader.currentEventName = null;
                            ScriptLoader.currentEvents = null;
                            ScriptLoader.hasDelayBefore = Kleenean.FALSE;
                            continue;
                        }
                        if (Skript.logVeryHigh() && !Skript.debug()) {
                            Skript.info("loading trigger '" + event + "'");
                        }
                        if (StringUtils.startsWithIgnoreCase(event, "on ")) {
                            event = event.substring("on ".length());
                        }
                        if ((event = ScriptLoader.replaceOptions(event)) == null || (parsedEvent = SkriptParser.parseEvent(event, "can't understand this event: '" + node.getKey() + "'")) == null) continue;
                        if (Skript.debug() || node.debug()) {
                            Skript.debug(String.valueOf(event) + " (" + ((SkriptEvent)parsedEvent.second).toString(null, true) + "):");
                        }
                        ScriptLoader.currentEvent = (SkriptEvent)parsedEvent.second;
                        ScriptLoader.currentEventName = ((SkriptEventInfo)parsedEvent.first).getName().toLowerCase(Locale.ENGLISH);
                        ScriptLoader.currentEvents = ((SkriptEventInfo)parsedEvent.first).events;
                        ScriptLoader.hasDelayBefore = Kleenean.FALSE;
                        trigger = new Trigger(config.getFile(), event, (SkriptEvent)parsedEvent.second, ScriptLoader.loadItems(node));
                        ScriptLoader.currentEvent = null;
                        ScriptLoader.currentEventName = null;
                        ScriptLoader.currentEvents = null;
                        ScriptLoader.hasDelayBefore = Kleenean.FALSE;
                        if (parsedEvent.second instanceof SelfRegisteringSkriptEvent) {
                            ((SelfRegisteringSkriptEvent)parsedEvent.second).register(trigger);
                            SkriptEventHandler.addSelfRegisteringTrigger(trigger);
                        } else {
                            SkriptEventHandler.addTrigger(((SkriptEventInfo)parsedEvent.first).events, trigger);
                        }
                        script.triggers.add(trigger);
                        ++numTriggers;
                    }
                    if (Skript.logHigh()) {
                        Skript.info("loaded " + numTriggers + " trigger" + (numTriggers == 1 ? "" : "s") + " and " + numCommands + " command" + (numCommands == 1 ? "" : "s") + " from '" + config.getFileName() + "'");
                    }
                    ScriptLoader.currentScript = null;
                }
                finally {
                    numErrors.stop();
                }
                if (SkriptConfig.enableScriptCaching.value().booleanValue() && numErrors.getCount() > 0) {
                    out = null;
                    try {
                        cache.getParentFile().mkdirs();
                        out = new ObjectOutputStream(new FileOutputStream(cache));
                        out.writeLong(f.lastModified());
                        out.writeObject(script);
                    }
                    catch (NotSerializableException e) {
                        Skript.exception((Throwable)e, new String[]{"Cannot cache " + f.getName()});
                        if (out != null) {
                            out.close();
                        }
                        cache.delete();
                        if (out != null) {
                            out.close();
                        }
                        break block75;
                    }
                    catch (IOException e) {
                        try {
                            Skript.warning("Cannot cache " + f.getName() + ": " + e.getLocalizedMessage());
                            if (out != null) {
                                out.close();
                            }
                            cache.delete();
                            break block75;
                        }
                        catch (Throwable var9_20) {
                            throw var9_20;
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                    }
                    if (out == null) break block75;
                    out.close();
                }
            }
            var21_40 = new ScriptInfo(1, numTriggers, numCommands);
            return var21_40;
        }
        catch (IOException e) {
            Skript.error("Could not load " + f.getName() + ": " + ExceptionUtils.toString(e));
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, new String[]{"Could not load " + f.getName()});
        }
        finally {
            SkriptLogger.setNode(null);
        }
        return new ScriptInfo();
    }

    static final ScriptInfo unloadScripts(File folder) {
        File[] files;
        ScriptInfo info = new ScriptInfo();
        File[] fileArray = files = folder.listFiles(scriptFilter);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                info.add(ScriptLoader.unloadScripts(f));
            } else if (f.getName().endsWith(".sk")) {
                info.add(ScriptLoader.unloadScript(f));
            }
            ++n2;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ScriptInfo unloadScript(File script) {
        ScriptInfo info = SkriptEventHandler.removeTriggers(script);
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            loadedScripts.subtract(info);
        }
        return info;
    }

    public static final String replaceOptions(String s) {
        if (s == null) {
            return null;
        }
        return StringUtils.replaceAll((CharSequence)s, "\\{@(.+?)\\}", new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                String option = currentOptions.get(m.group(1));
                if (option == null) {
                    Skript.error("undefined option " + m.group());
                    return null;
                }
                return option;
            }
        });
    }

    public static ArrayList<TriggerItem> loadItems(SectionNode node) {
        if (Skript.debug()) {
            indentation = String.valueOf(indentation) + "    ";
        }
        ArrayList<TriggerItem> items = new ArrayList<TriggerItem>();
        Kleenean hadDelayBeforeLastIf = Kleenean.FALSE;
        for (Node n : node) {
            Kleenean hadDelayBefore;
            Condition cond;
            String l;
            String name;
            SkriptLogger.setNode(n);
            if (n instanceof SimpleNode) {
                Statement stmt;
                SimpleNode e = (SimpleNode)n;
                String s = ScriptLoader.replaceOptions(e.getKey());
                if (s == null || !SkriptParser.validateLine(s) || (stmt = Statement.parse(s, "Can't understand this condition/effect: " + s)) == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + stmt.toString(null, true));
                }
                items.add(stmt);
                if (!(stmt instanceof Delay)) continue;
                hasDelayBefore = Kleenean.TRUE;
                continue;
            }
            if (!(n instanceof SectionNode) || (name = ScriptLoader.replaceOptions(n.getKey())) == null || !SkriptParser.validateLine(name)) continue;
            if (StringUtils.startsWithIgnoreCase(name, "loop ")) {
                Expression<Object> loopedExpr;
                l = name.substring("loop ".length());
                RetainingLogHandler h = SkriptLogger.startRetainingLog();
                try {
                    loopedExpr = new SkriptParser(l).parseExpression(Object.class);
                    if (loopedExpr != null) {
                        loopedExpr = loopedExpr.getConvertedExpression(Object.class);
                    }
                    if (loopedExpr == null) {
                        h.printErrors("Can't understand this loop: '" + name + "'");
                        continue;
                    }
                    h.printLog();
                }
                finally {
                    h.stop();
                }
                if (loopedExpr.isSingle()) {
                    Skript.error("Can't loop " + loopedExpr + " because it's only a single value");
                    continue;
                }
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + "loop " + loopedExpr.toString(null, true) + ":");
                }
                Kleenean hadDelayBefore2 = hasDelayBefore;
                items.add(new Loop(loopedExpr, (SectionNode)n));
                if (hadDelayBefore2 == Kleenean.TRUE || hasDelayBefore == Kleenean.FALSE) continue;
                hasDelayBefore = Kleenean.UNKNOWN;
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(name, "while ")) {
                l = name.substring("while ".length());
                Condition c = Condition.parse(l, "Can't understand this condition: " + l);
                if (c == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + "while " + c.toString(null, true) + ":");
                }
                Kleenean hadDelayBefore3 = hasDelayBefore;
                items.add(new While(c, (SectionNode)n));
                if (hadDelayBefore3 == Kleenean.TRUE || hasDelayBefore == Kleenean.FALSE) continue;
                hasDelayBefore = Kleenean.UNKNOWN;
                continue;
            }
            if (name.equalsIgnoreCase("else")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional) || ((Conditional)items.get(items.size() - 1)).hasElseClause()) {
                    Skript.error("'else' has to be placed just after an 'if' or 'else if' section");
                    continue;
                }
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + "else:");
                }
                Kleenean hadDelayAfterLastIf = hasDelayBefore;
                hasDelayBefore = hadDelayBeforeLastIf;
                ((Conditional)items.get(items.size() - 1)).loadElseClause((SectionNode)n);
                hasDelayBefore = hadDelayBeforeLastIf.or(hadDelayAfterLastIf.and(hasDelayBefore));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(name, "else if ")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional) || ((Conditional)items.get(items.size() - 1)).hasElseClause()) {
                    Skript.error("'else if' has to be placed just after another 'if' or 'else if' section");
                    continue;
                }
                cond = Condition.parse(name = name.substring("else if ".length()), "can't understand this condition: '" + name + "'");
                if (cond == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(indentation) + "else if " + cond.toString(null, true));
                }
                Kleenean hadDelayAfterLastIf = hasDelayBefore;
                hasDelayBefore = hadDelayBeforeLastIf;
                ((Conditional)items.get(items.size() - 1)).loadElseIf(cond, (SectionNode)n);
                hasDelayBefore = hadDelayBeforeLastIf.or(hadDelayAfterLastIf.and(hasDelayBefore.and(Kleenean.UNKNOWN)));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(name, "if ")) {
                name = name.substring(3);
            }
            if ((cond = Condition.parse(name, "can't understand this condition: '" + name + "'")) == null) continue;
            if (Skript.debug() || n.debug()) {
                Skript.debug(String.valueOf(indentation) + cond.toString(null, true) + ":");
            }
            hadDelayBeforeLastIf = hadDelayBefore = hasDelayBefore;
            items.add(new Conditional(cond, (SectionNode)n));
            hasDelayBefore = hadDelayBefore.or(hasDelayBefore.and(Kleenean.UNKNOWN));
        }
        int i = 0;
        while (i < items.size() - 1) {
            ((TriggerItem)items.get(i)).setNext(items.get(i + 1));
            ++i;
        }
        SkriptLogger.setNode(node);
        if (Skript.debug()) {
            indentation = indentation.substring(0, indentation.length() - 4);
        }
        return items;
    }

    static Trigger loadTrigger(SectionNode node) {
        String event = node.getKey();
        if (event.toLowerCase().startsWith("on ")) {
            event = event.substring("on ".length());
        }
        Pair<SkriptEventInfo<?>, SkriptEvent> parsedEvent = SkriptParser.parseEvent(event, "can't understand this event: '" + node.getKey() + "'");
        currentEvent = (SkriptEvent)parsedEvent.second;
        currentEvents = ((SkriptEventInfo)parsedEvent.first).events;
        Trigger t = new Trigger(null, event, (SkriptEvent)parsedEvent.second, ScriptLoader.loadItems(node));
        currentEvent = null;
        currentEvents = null;
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedScripts() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedCommands() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.commands;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedTriggers() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.triggers;
        }
    }

    public static final boolean isCurrentEvent(Class<? extends Event> event) {
        return CollectionUtils.containsSuperclass(currentEvents, event);
    }

    public static final boolean isCurrentEvent(Class<? extends Event> ... events) {
        return CollectionUtils.containsAnySuperclass(currentEvents, events);
    }

    public static class ScriptInfo {
        public int files;
        public int triggers;
        public int commands;

        public ScriptInfo() {
        }

        public ScriptInfo(int numFiles, int numTriggers, int numCommands) {
            this.files = numFiles;
            this.triggers = numTriggers;
            this.commands = numCommands;
        }

        public void add(ScriptInfo other) {
            this.files += other.files;
            this.triggers += other.triggers;
            this.commands += other.commands;
        }

        public void subtract(ScriptInfo other) {
            this.files -= other.files;
            this.triggers -= other.triggers;
            this.commands -= other.commands;
        }
    }

    private static final class SerializedScript
    implements Serializable {
        static final long serialVersionUID = -6209530262798192214L;
        public final List<Trigger> triggers = new ArrayList<Trigger>();
        public final List<ScriptCommand> commands = new ArrayList<ScriptCommand>();

        private SerializedScript() {
        }
    }
}

