/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util;

import ch.njol.util.iterator.ReversedListIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ReversedListView<T>
implements List<T> {
    private final List<T> list;

    public ReversedListView(List<T> list) {
        assert (list != null);
        this.list = list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new ReversedListIterator<T>(this.list);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ReversedListIterator<T>(this.list);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ReversedListIterator<T>(this.list, index);
    }

    @Override
    public Object[] toArray() {
        Object[] r = new Object[this.size()];
        int i = 0;
        for (T o : this) {
            r[i++] = o;
        }
        return r;
    }

    @Override
    public <R> R[] toArray(R[] a) {
        R[] t = a.length >= this.size() ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        int i = 0;
        for (T o : this) {
            t[i++] = o;
        }
        if (t.length > this.size()) {
            t[this.size()] = null;
        }
        return t;
    }

    @Override
    public boolean add(T e) {
        this.list.add(0, e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.list.lastIndexOf(o);
        if (i != -1) {
            this.list.remove(i);
        }
        return i != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(0, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.list.addAll(this.size() - index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public T get(int index) {
        return this.list.get(this.size() - index - 1);
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(this.size() - index - 1, element);
    }

    @Override
    public void add(int index, T element) {
        this.list.add(this.size() - index, element);
    }

    @Override
    public T remove(int index) {
        return this.list.remove(this.size() - index - 1);
    }

    @Override
    public int indexOf(Object o) {
        return this.size() - this.list.lastIndexOf(o) - 1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.size() - this.list.indexOf(o) - 1;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new ReversedListView<T>(this.list.subList(this.size() - toIndex, this.size() - fromIndex));
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (T e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        if (other.size() != this.size()) {
            return false;
        }
        Iterator os = other.iterator();
        for (T t : this) {
            Object o = os.next();
            if (!(t == null ? o != null : !t.equals(o))) continue;
            return false;
        }
        return true;
    }
}

